; BUFFERS.INC
; (c) 1989, 1990 Ashok P. Nadkarni
;
; Various definitions for string buffer structures in CMDEDIT.
;

WANT_MARKERS	equ	0		;1 if the marker routines are wanted
;					 0 otherwise. Note Markers have not
;					 been tested and are not used in
;					 CMDEDIT. Keep this defined as 0.

; $STRING_STACK is a descriptor for a buffer that is maintained as a stack of
; strings. Each string has a one byte header and a one byte trailer that
; contain the length of the string. These are used to traverse up and down
; the stack allowing access to elements inside the stack. The stack grows
; upwards in memory. The string header appears at the lower address followed
; by the string itself and then the trailer.
;
; The string can be of length between 0 and 255 bytes
;
; There is a NULL string always present at the bottom of the stack. This
; consists of a 0 byte at location low followed by another 0 byte (these
; bytes are the header and trailer respectively and denote a 0 length
; string. When the stack is empty, a zero length string is returned by
; operations like popping the stack. Stack empty is true IFF 
;	top = cur = low+1
;	
; MARKERS :
; The user can also set markers to point at the various elements in the
; stack. These markers are accessed strictly as a stack through various
; routines. When a string associated with a marker is deleted, the marker
; is set to point to the string above the deleted string except when the
; string was the topmost string in which case the marker will point to
; the new top of stack (which may even be the sentinel). Thus the markers
; will "percolate" upwards through the stack as strings are deleted until
; they reach the top. Note that if a marker points to the top of the stack,
; and a new string is pushed onto the stack, the marker still points to the
; old top of stack. When the stack is empty, any existing markers will point
; to the sentinel null string and then keep pointing there even if strings
; are added. (The strstk_purge_marks function will delete these markers).
; The marker stack is itself stored at the top of the buffer and grows 
; downwards.
;
; Each element of the descriptor structure is as follows :
;	low -  Contains the lowest address of the buffer.
;	high - Contains the highest address of the buffer. 
;	top - Points to the trailer of the topmost string.
;		Note that this is the highest occupied location of in
;		the buffer. 
;	cur - cur is a pointer to the "current" string within the stack.
;		Most requested operations are done with respect to the
;		"current" string.
;	savecur - used to temporarily hold a previous value of cur while
;		  cur is moved around.
;	topmark - location where the last marker is stored.
;		  = high+1 if no markers.
;
;
; For example the following diagram shows these various relationships
; and structures.
;
; Assuming the buffer contains two strings and a single mark pointing
; to the first string,
;
;	Descriptor			Buffer (range 100h - 10F)
;					+---------------+
;	low	= 100h		10F	| 	01h	|
;					+---------------+
;	high	= 10Fh		10E	| 	05h	|
;					+---------------+
;	top	= 10Ah		10D	|    	-	|
;					+---------------+
;	topmark = 10Eh		10C	|	-	|
;					+---------------+
;				10B	|	-	|
;					+---------------+
;				10A	|  Len(B)=3	|
;					+---------------+
;				109	|	b3	|
;					+---------------+
;				108	|	b2	|
;					+---------------+
;				107	|	b1	|
;					+---------------+
;				106	|  Len(B)=3	|
;					+---------------+
;				105	|  Len(A)=2	|
;					+---------------+
;				104	|	a2	|
;					+---------------+
;				103	|  	a1	|
;					+---------------+
;				102	|  Len(A)=2	|
;					+---------------+
;				101	|	0	|
;					+---------------+
;				100	|       0	|
;					+---------------+
;
; The functions defined for these buffers make specific assumptions about
; how these are manipulated so the user code should NOT write to them directly.
; 

$string_stack	STRUC
top		dw	?
cur		dw	?
savecur		dw	?
low_end		dw	?
high_end	dw	?
topmark		dw	?		;This field must be present
; 					 even if WANT_MARKERS is 0
$string_stack	ENDS


	IFDEF	STRSTACK_ASM

	PUBLIC	strstk_init
	PUBLIC	strstk_reset
	PUBLIC	strstk_push
	PUBLIC	strstk_makespace
	PUBLIC	strstk_space
	PUBLIC	strstk_fwd_match
	PUBLIC	strstk_bck_match
	PUBLIC	strstk_fwd_find
	PUBLIC	strstk_bck_find
	PUBLIC	strstk_settop
	PUBLIC	strstk_setbot
	PUBLIC	strstk_kill
	PUBLIC	strstk_copy
	PUBLIC	strstk_compare
	PUBLIC	strstk_prefix
	PUBLIC	strstk_save_cur
	PUBLIC	strstk_restore_cur
	PUBLIC	strstk_output				;added by wd
	ELSE

CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	EXTRN	strstk_init:PROC
	EXTRN	strstk_reset:PROC
	EXTRN	strstk_push:PROC
	EXTRN	strstk_makespace:PROC
	EXTRN	strstk_space:PROC
	EXTRN	strstk_fwd_match:PROC
	EXTRN	strstk_bck_match:PROC
	EXTRN	strstk_fwd_find:PROC
	EXTRN	strstk_bck_find:PROC
	EXTRN	strstk_settop:PROC
	EXTRN	strstk_setbot:PROC
	EXTRN	strstk_kill:PROC
	EXTRN	strstk_copy:PROC
	EXTRN	strstk_compare:PROC
	EXTRN	strstk_prefix:PROC
	EXTRN	strstk_save_cur:PROC
	EXTRN	strstk_restore_cur:PROC
	EXTRN	strstk_output:PROC			;added by wd
CSEG	ENDS

	ENDIF
