; UTL.ASM
; (c) 1989, 1990 Ashok P. Nadkarni
;
; General utility functions for CMDEDIT. SMALL model only. Also assume 
; ES == DS. 
;

	INCLUDE common.inc
	INCLUDE	general.inc
	INCLUDE	ascii.inc
	INCLUDE dos.inc
	INCLUDE buffers.inc

	PUBLIC	stre_cmp
	PUBLIC	tolower
	PUBLIC	xlate_lower
	PUBLIC	isalphnum
;	PUBLIC	iscntrl 		; removed by jmh
	PUBLIC	isspace
	PUBLIC	isdelim
	PUBLIC	bell
	PUBLIC	push_string
	PUBLIC	push_word
	PUBLIC	skip_nonwhite
	PUBLIC	skip_whitespace
	PUBLIC	skip_nondelim
	PUBLIC	output_newline
	PUBLIC	output_counted_string
	PUBLIC	dosify_line		; added by wd
	PUBLIC	redirect_stdout 	; added by jmh
	PUBLIC	restore_stdout		; ditto
	
	EXTRN	silent:BYTE
	EXTRN	lastchar:WORD
	EXTRN	linebuf:BYTE
	EXTRN	stdout_handle:WORD	; added by jmh


CSEG	SEGMENT	BYTE PUBLIC 'CODE'

DGROUP	GROUP	CSEG

	ASSUME	CS:DGROUP,DS:DGROUP,ES:DGROUP,SS:DGROUP

;+
; FUNCTION : stre_cmp
;
;	Does a case-insensitve comparison of two strings of equal length.
;
; Parameters:
;	DS:SI :=	Address of string 1.
;	ES:DI :=	Address of string 2.
;	CX    :=	Length.
;
; Returns:
;	If string 1 = string 2, ZF = 1, CF = 0.
;	If string 1 < string 2, ZF = 0, CF = 1.
;	If string 1 > string 2, ZF = 0, CF = 0.
; Registers AX,CX destroyed.
;-
stre_cmp proc near
	@save	si,di
	dec	si		;Prime for loop
	dec	di
	xor	ax,ax		;Clear flags
	jcxz	@stre_cmp_99
@stre_cmp_10:
	cmpsb			;Point SI,DI to next byte
	mov	al,[si]		;String 1 byte
	call	near ptr tolower ;al := Uppercase version
	xchg	al,ah		;Save it.
	mov	al,ES:[di]	;Ditto for string 2
	call	near ptr tolower ;al := Uppercase version
	cmp	ah,al		;Compare string 1 with string 2
@stre_cmp_20:
	loope	@stre_cmp_10	;Keep looping as long as equal
@stre_cmp_99:
	@restore
	ret
stre_cmp endp


;+
; FUNCTION : tolower
;
;	Converts the character in AL to lower case if it is a upper case
;	character, else leaves it unchanged.
;
; Parameters:
;	Al :=	character
;
; Returns:
;	AL :=	lowercase version or unchanged
;-
tolower	proc near
	cmp	al,'A'
	jb	@tolower_99
	cmp	al,'Z'
	ja	@tolower_99
	add	al,20h
@tolower_99:
	ret
tolower	endp



;+
; FUNCTION : xlate_lower
;
;	Converts the passed string to lower case.
;
; Parameters:
;	AX :=	length of string
;	SI :=	address of string
;
; Returns:
;	Nothing.
;
; Registers destroyed:
;	AX,CX
;-
xlate_lower proc near
	@save	si,di
	mov	di,si
	mov	cx,ax
	jcxz	@xlate_lower_99

@xlate_lower_10:
	lodsb
	call	near ptr tolower
	stosb
	loop	@xlate_lower_10
	
@xlate_lower_99:
	@restore
	ret
xlate_lower endp




;+
; FUNCTION : isalphnum
;
;	Test if the character is alphanumeric.
;
; Parameters:
;	AL	= character
;
; Returns:
;	ZF	= 0 if alphanumeric (changed from CF by jmh)
;		  1 if not
; Register(s) destroyed:
;-
isalphnum proc near
	cmp	al,'0'
	jc	@isalphnum_99		;Not alphanumeric
	cmp	al,'9'+1
	jc	@isalphnum_98		;Number
	cmp	al,'A'
	jc	@isalphnum_99		;Not alphanumeric
	cmp	al,'Z'+1
	jc	@isalphnum_98		;Uppercase letter
	cmp	al,'a'
	jc	@isalphnum_99		;Not alphanumeric
	cmp	al,'z'+1
@isalphnum_98:
	and	al,al			;AL is not zero so this sets NZ
	ret
@isalphnum_99:
	test	al,0			;This sets ZF
	ret
isalphnum endp


comment * removed by jmh
;+
; FUNCTION : iscntrl
;
;	Check if control character and DEL (00h-1Fh and 0FFh).
;
; Parameters:
;	AL	= character to be checked
;
; Returns:
;	CF	= 0 if AL is a control character or DEL
;		  1 not a control char or DEL
; Register(s) destroyed:
;-
iscntrl	proc	near
	cmp	al,DEL
	jne	@iscntrl_99
	cmp	al,' '
	cmc
@iscntrl_99:
	ret
iscntrl	endp
*


;+
; FUNCTION : isspace
;
;	Check if a character is a SPACE or a TAB
;
; Parameters:
;	AL	= character to check
;
; Returns:
;	ZF	= 1 if AL is a space or a tab
;		  0 otherwise
; Register(s) destroyed:
;
;-
isspace	proc	near
	cmp	al,TAB
	je	@isspace_99
	cmp	al,SPACE
@isspace_99:
	ret
isspace	endp



;+
; FUNCTION : isdelim
;
;	Check if a character is an MSDOS delimiter.
;
; Parameters:
;	AL	= character to check
;
; Returns:
;	ZF	= 1 if AL is a delimiter
;		  0 otherwise
; Register(s) destroyed:
;
;-
isdelim	proc	near
	call	near ptr isspace	;Check if space or tab
	je	@isdelim_99		;Yes, go return
	cmp	al,'/'
	je	@isdelim_99		;Yes, go return
	cmp	al,'|'
	je	@isdelim_99		;Yes, go return
	cmp	al,'<'
	je	@isdelim_99		;Yes, go return
	cmp	al,'>'
@isdelim_99:
	ret
isdelim	endp



;+
; FUNCTION : skip_whitespace
;
;	Searches for the next non-whitespace character in a given string.
;
; Parameters:
;	SI	-> pointer to string
;	CX	== num chars in the string
;
; Returns:
;	CF	= 1 if end-of string reached else 0
;	SI	->next non-whitespace character or end-of-string
;	CX	<-num remaining characters including one pointed to by SI
;
; Register(s) destroyed:
;	AX
;-
skip_whitespace proc near
	jcxz	@skip_whitespace_98		;Empty string
@skip_whitespace_10:
	lodsb					;AL<-next char
	call	near ptr isspace		;Whitespace character ?
	loope	@skip_whitespace_10		;Repeat until
;						 non-whitespace or string ends
	je	@skip_whitespace_98		;End-of-string
; Non-whitespace char found
	dec	si				;SI->non-whitespace char
	inc	cx				;CX<-remaining number of bytes
	clc					;CF<-0 (char found)
	jmp	short @skip_whitespace_99

@skip_whitespace_98:
; End of string reached.
	stc					;Set CF

@skip_whitespace_99:
	ret
skip_whitespace endp




;+ FUNCTION : skip_nonwhite, skip_nondelim
;
;	Searches for the next whitespace character / delimiter in a given
;	string.
;
; Parameters:
;	SI	-> pointer to string
;	CX	== num chars in the string
;
; Returns:
;	CF	= 1 if end-of string reached else 0
;	SI	->next whitespace character or end-of-string
;	CX	<-num remaining characters including one pointed to by SI
;
; Register(s) destroyed:
;	AX
;-
skip_non proc near
skip_nonwhite LABEL near
	push	dx
	mov	dx,offset DGROUP:isspace
	jmp	short @skip_non	

skip_nondelim LABEL near
	push	dx
	mov	dx,offset DGROUP:isdelim
@skip_non:
	jcxz	@skip_non_98			;Empty string
@skip_non_10:
	lodsb					;AL<-next char
	call	dx				;nonwhite / delimiter
;						 character ? 
	loopne	@skip_non_10			;Repeat until
;						 whitespace or string ends
	jne	@skip_non_98			;End-of-string
; whitespace char found
	dec	si				;SI->whitespace char
	inc	cx				;CX<-remaining number of bytes
	clc					;CF<-0 (char found)
	jmp	short @skip_non_99

@skip_non_98:
; End of string reached.
	stc					;Set CF

@skip_non_99:
	pop	dx
	ret
skip_non endp






;+
; FUNCTION : push_word
;
;	Looks for the next word (delimited by whitespace) and pushes it
;	onto the specified string stack.
;
; Parameters:
;	BX	-> strstack descriptor
;	SI	-> string
;	CX	== length of string (< 256)
;
; Returns:
;	AX	<- 0 if no errors
;		  -1 if no room in stack
;		  +1 if no word in string
;	SI	-> char after first word (or end-of-string)
;	CX	<- num remaining characters
;
; Register(s) destroyed:
;	DX
;-
push_word proc	near
; Skip forward to first word
	call	near ptr skip_whitespace	;Returns
;						 SI->start of word
;						 CX<-remaining chars
	jcxz	@push_word_98			;No words in line
	mov	dx,si				;DX->start of word
	push	cx				;Save count
	call	near ptr skip_nonwhite		;Find end of word
;						 SI->beyond word
;						 CX<-remaining chars
	pop	ax
	sub	ax,cx				;AX<-length of word
	push	cx				;Save remaining char count
	xor	cx,cx				;CX<-0 (don't force push)
	call	near ptr strstk_push		;Store macro name into
;						 macro stack. Params
;						 AX,BX,CX,DX
;						 Returns Cf = 0 or 1
	pop	cx				;CX<-remaining character
;	Assume no error
	mov	ax,0	;DON'T DO xor ax,ax SINCE CF to be preserved
	jnc	@push_word_99			;Jump if no error
	dec	ax				;Error AX <- -1
;	jmp	short @push_word_99		;Exit (removed by jmh)
	ret

@push_word_98:
; No words found in line. Set return codes.
	mov	ax,1				;Code for blank line

@push_word_99:
	ret
push_word	endp





;+
; FUNCTION : push_string
;
;	Pushed the specified string onto the specified stack.
;
; Parameters:
;	BX	-> strstack descriptor
;	SI	-> string
;	CX	== length of string must be < 256
;
; Returns:
;	CF	<- 0 if no errors
;		   1 if no room in stack
;
; Register(s) destroyed:
;	AX,CX,DX
;-
push_string proc	near
	mov	dx,si				;DX->start of string
	mov	ax,cx				;AX<-length of string
	xor	cx,cx				;CX<-0 (don't force push)
	call	near ptr strstk_push		;Store macro name into
;						 macro stack. Params
;						 AX,BX,CX,DX
;						 Returns Cf = 0 or 1
	ret
push_string	endp



;+
; FUNCTION : bell
;
;	Called to ring the bell.
;
; Parameters:
;	None.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;	AX
;-
bell	proc	near
	cmp	silent,1
	je	@bell_99
	@DispCh	BEL
@bell_99:
	ret
bell	endp


;+
; FUNCTION : output_counted_string
;
; Parameters :
;	CX - Number of bytes to display
;	DX - address of string
; Registers destroyed:
;	AX,BX,CX,DX
output_counted_string proc near
	mov	ah,40h
	mov	bx,1				;stdout handle
	int	21h				;Params ax,bx,cx,dx
	ret
output_counted_string endp

;+
; FUNCTION: output_newline
;
; Registers destroyed:
;	AX,BX,CX,DX
;-
output_newline proc near
	@DispCh	CR
	@DispCh	LF
	ret
output_newline endp


;+
; FUNCTION: dosify_line by wd
;
; Parameters:
;	SI -> string to massage
;	CX =  line length
; Registers destroyed:
;	AX,BX,CX,DX
;-
dosify_line proc near
	jcxz	@dosify_line_99
	push	cx
	push	si
@dosify_line_10:
	lodsb				;al = currentchar
	cmp	al,'/'			;is this a slash?
	je	@dosify_line_20		;yes, change it
	cmp	al,'\'			;is this a backslash?
	je	@dosify_line_25		;yes, check it
	cmp	al,'-'			;is this a dash
	jne	@dosify_line_40		;no, leave it alone

	cmp	byte ptr [si-2],' '	;is lastchar a space?
	jne	@dosify_line_40		;no, leave it alone
	mov	al,'/'			;yes, change " -" to " /"
	jmp	short @dosify_line_30
@dosify_line_20:
	mov	al,'\'			;change '/' to '\'
@dosify_line_25:			;see if this is a trailing slash
	cmp	cl,1			;is it at the end of the line?
	je	@dosify_line_27		;yes, drop it
	cmp	byte ptr [si],' '	;is it before a space?
	jne	@dosify_line_30		;no, leave it alone
@dosify_line_27:
	mov	al,' '			;change trailing slash to a space
@dosify_line_30:
	mov	[si-1],al		;store the revised character
@dosify_line_40:
	loop	@dosify_line_10
	pop	si
	pop	cx
@dosify_line_99:
	ret
dosify_line endp



;+
; FUNCTION: redirect_stdout by jmh (14 March 1997)
;
;	Provides a means of redirecting internal commands. The file is always
;	created, so be careful.
;
; Parameters:
;	SI -> pointer to the string containing the filename (which gets null-
;	      terminated)
;
; Returns:
;	CF = 1 if no file, or bad filename. Output goes to screen.
;	     0 if redirection is to take place.
;
; Register(s) destroyed:
;	AX,BX,CX,DX,SI
;-
redirect_stdout proc near
	call	near ptr skip_whitespace
	jc	@no_file
	cmp	al,'>'                          ;Skip past the redirection
	jne	@no_symbol			; symbol, if it was used
	inc	si
	dec	cx
@no_symbol:
	mov	dx,si				;DX -> filename
	call	near ptr skip_nonwhite
	sub	cx,cx				;Normal attributes
	mov	byte ptr [si],cl		;Add the zero terminator
	mov	ah,3ch				;Create the file
	int	21h
	jc	@no_file			;Bad filename?
	mov	cx,ax
	mov	ah,45h				;Duplicate stdout
	mov	bx,1
	int	21h
	mov	stdout_handle,ax		;Remember the duplicate's handle
	xchg	bx,cx				;BX -> file, CX -> stdout
	jmp	short @duplicate		;Duplicate the file onto stdout
@no_file:
	mov	stdout_handle,-1
	ret
redirect_stdout endp


;+
; FUNCTION: restore_stdout by jmh (14 March 1997)
;
;	Restore output to the screen after it's been redirected.
;
; Parameters:
;
; Returns:
;
; Registers destroyed:
;	AX,BX,CX
;-
restore_stdout proc near
	mov	bx,stdout_handle
	cmp	bx,-1
	je	@no_redirect
	mov	cx,1
@duplicate label near
	mov	ah,46h				;Put stdout back to screen
	int	21h
	mov	ah,3eh				;Close stdout's duplicate
	int	21h
@no_redirect:
	ret
restore_stdout endp


CSEG	ENDS

	END

