/*-------------------------------------
   EMF6.C -- Enhanced Metafile Demo #6
             (c) Charles Petzold, 1994
  -------------------------------------*/

#include <windows.h>
#include <stdlib.h>

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "EMF6" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Enhanced Metafile Demo #6",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

int CALLBACK EnhMetaFileProc (HDC hdc, HANDLETABLE * pHandleTable,
                              CONST ENHMETARECORD * pEmfRecord, int nHandles,
                              LPARAM pData)
     {
     ENHMETARECORD * pEmfr ;

     pEmfr = (ENHMETARECORD *) malloc (pEmfRecord->nSize) ;

     memcpy (pEmfr, pEmfRecord, pEmfRecord->nSize) ;

     if (pEmfr->iType == EMR_RECTANGLE)

          {
          PlayEnhMetaFileRecord (hdc, pHandleTable, pEmfr, nHandles) ;

          pEmfr->iType = EMR_ELLIPSE ;
          }

     PlayEnhMetaFileRecord (hdc, pHandleTable, pEmfr, nHandles) ;

     free (pEmfr) ;

     return TRUE ;
     }

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
     {
     HDC          hdc, hdcEMF ;
     HENHMETAFILE hemf ;
     LOGBRUSH     lb ;
     PAINTSTRUCT  ps ;
     RECT         rect ;

     switch (message)
          {
          case WM_CREATE:
               hdcEMF = CreateEnhMetaFile (NULL, "emf6.emf", NULL,
                                           "EMF6\0EMF Demo #6\0") ;

               SelectObject (hdcEMF,
                    CreateSolidBrush (RGB (0, 0, 255))) ;

               lb.lbStyle = BS_SOLID ;
               lb.lbColor = RGB (255, 0, 0) ;
               lb.lbHatch = 0 ;

               SelectObject (hdcEMF,
                    ExtCreatePen (PS_SOLID | PS_GEOMETRIC, 5, &lb, 0, NULL)) ;

               Rectangle (hdcEMF, 100, 100, 201, 201) ;

               MoveToEx  (hdcEMF, 100, 100, NULL) ;
               LineTo    (hdcEMF, 200, 200) ;

               MoveToEx  (hdcEMF, 200, 100, NULL) ;
               LineTo    (hdcEMF, 100, 200) ;

               DeleteObject (
                    SelectObject (hdcEMF,
                         GetStockObject (BLACK_PEN))) ;

               DeleteObject (
                    SelectObject (hdcEMF,
                         GetStockObject (WHITE_BRUSH))) ;

               hemf = CloseEnhMetaFile (hdcEMF) ;

               DeleteEnhMetaFile (hemf) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               GetClientRect (hwnd, &rect) ;

               rect.left   =     rect.right  / 4 ;
               rect.right  = 3 * rect.right  / 4 ;
               rect.top    =     rect.bottom / 4 ;
               rect.bottom = 3 * rect.bottom / 4 ;

               hemf = GetEnhMetaFile ("emf6.emf") ;

               EnumEnhMetaFile (hdc, hemf, EnhMetaFileProc, NULL, &rect) ;

               DeleteEnhMetaFile (hemf) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
