//***************************************************************************
//
//  CtlDemo.cpp
//
//***************************************************************************

#include <afxwin.h>
#include "Resource.h"
#include "CtlDemo.h"

CMyApp myApp;

/////////////////////////////////////////////////////////////////////////////
// CMyApp member functions

BOOL CMyApp::InitInstance ()
{
    m_pMainWnd = new CMainWindow;
    m_pMainWnd->ShowWindow (m_nCmdShow);
    m_pMainWnd->UpdateWindow ();
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainWindow message map and member functions

BEGIN_MESSAGE_MAP (CMainWindow, CFrameWnd)
    ON_WM_CREATE ()
    ON_BN_CLICKED (IDC_RED, OnRedButtonClicked)
    ON_BN_CLICKED (IDC_GREEN, OnGreenButtonClicked)
    ON_BN_CLICKED (IDC_BLUE, OnBlueButtonClicked)
END_MESSAGE_MAP ()

CMainWindow::CMainWindow ()
{
    CString strWndClass = AfxRegisterWndClass (
        0,
        myApp.LoadStandardCursor (IDC_ARROW),
        (HBRUSH) (COLOR_3DFACE + 1),
        myApp.LoadStandardIcon (IDI_APPLICATION)
    );

    Create (strWndClass, "MFC 4.0 Control Demo");
}

int CMainWindow::OnCreate (LPCREATESTRUCT lpcs)
{
    if (CFrameWnd::OnCreate (lpcs) == -1)
        return -1;

    CClientDC dc (this);
    int nHeight = -((dc.GetDeviceCaps (LOGPIXELSY) * 8) / 72);

    m_font.CreateFont (nHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        DEFAULT_CHARSET, OUT_CHARACTER_PRECIS, CLIP_CHARACTER_PRECIS,
        DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "MS Sans Serif");

    CFont* pOldFont = dc.SelectObject (&m_font);
    TEXTMETRIC tm;
    dc.GetTextMetrics (&tm);
    m_cxChar = tm.tmAveCharWidth;
    m_cyChar = tm.tmHeight + tm.tmExternalLeading;
    dc.SelectObject (pOldFont);

    m_ctlGroupBox1.Create ("Sample text", WS_CHILD | WS_VISIBLE |
        BS_GROUPBOX, CRect (m_cxChar * 2, m_cyChar, m_cxChar * 62,
        m_cyChar * 8), this, UINT (-1));

    m_ctlText.Create ("Click a button to change my color",
        WS_CHILD | WS_VISIBLE | SS_CENTER, CRect (m_cxChar * 4, m_cyChar * 4,
        m_cxChar * 60, m_cyChar * 6), this);

    m_ctlGroupBox2.Create ("Color", WS_CHILD | WS_VISIBLE |
        BS_GROUPBOX, CRect (m_cxChar * 64, m_cyChar, m_cxChar * 80,
        m_cyChar * 8), this, UINT (-1));

    m_ctlRadioButtonRed.Create ("Red", WS_CHILD | WS_VISIBLE | WS_GROUP |
        BS_AUTORADIOBUTTON, CRect (m_cxChar * 66, m_cyChar * 3,
        m_cxChar * 78, m_cyChar * 4), this, IDC_RED);

    m_ctlRadioButtonGreen.Create ("Green", WS_CHILD | WS_VISIBLE |
        BS_AUTORADIOBUTTON, CRect (m_cxChar * 66, (m_cyChar * 9) / 2,
        m_cxChar * 78, (m_cyChar * 11) / 2), this, IDC_GREEN);

    m_ctlRadioButtonBlue.Create ("Blue", WS_CHILD | WS_VISIBLE |
        BS_AUTORADIOBUTTON, CRect (m_cxChar * 66, m_cyChar * 6,
        m_cxChar * 78, m_cyChar * 7), this, IDC_BLUE);

    m_ctlRadioButtonRed.SetCheck (1);
    m_ctlText.SetTextColor (RGB (255, 0, 0));

    m_ctlGroupBox1.SetFont (&m_font, FALSE);
    m_ctlGroupBox2.SetFont (&m_font, FALSE);
    m_ctlRadioButtonRed.SetFont (&m_font, FALSE);
    m_ctlRadioButtonGreen.SetFont (&m_font, FALSE);
    m_ctlRadioButtonBlue.SetFont (&m_font, FALSE);

    m_ctlEditListBox.CreateEx (WS_EX_CLIENTEDGE, "listbox", NULL,
        WS_CHILD | WS_VISIBLE | WS_BORDER | WS_VSCROLL | LBS_SORT,
        m_cxChar * 2, m_cyChar * 10, m_cxChar * 50, m_cyChar * 9,
        m_hWnd, (HMENU) -1);

    m_ctlEditListBox.SetFont (&m_font, FALSE);

    CString string;
    for (int i=1; i<=8; i++) {
        string.Format ("This is editable list box item no. %d", i);
        m_ctlEditListBox.AddString (string);
    }
    return 0;
}

void CMainWindow::OnRedButtonClicked ()
{
    m_ctlText.SetTextColor (RGB (255, 0, 0));
}

void CMainWindow::OnGreenButtonClicked ()
{
    m_ctlText.SetTextColor (RGB (0, 255, 0));
}

void CMainWindow::OnBlueButtonClicked ()
{
    m_ctlText.SetTextColor (RGB (0, 0, 255));
}

/////////////////////////////////////////////////////////////////////////////
// CColorText message map and member functions

BEGIN_MESSAGE_MAP (CColorText, CStatic)
    ON_WM_CTLCOLOR_REFLECT ()
END_MESSAGE_MAP ()

CColorText::CColorText ()
{
    m_crTextColor = RGB (0, 0, 0);
    m_crBkColor = ::GetSysColor (COLOR_3DFACE);
    m_brBkgnd.CreateSolidBrush (m_crBkColor);
}

void CColorText::SetTextColor (COLORREF crColor)
{
    m_crTextColor = crColor;
    Invalidate ();
}

void CColorText::SetBkColor (COLORREF crColor)
{
    m_crBkColor = crColor;
    m_brBkgnd.DeleteObject ();
    m_brBkgnd.CreateSolidBrush (crColor);
    Invalidate ();
}

HBRUSH CColorText::CtlColor (CDC* pDC, UINT nCtlColor)
{
    pDC->SetTextColor (m_crTextColor);
    pDC->SetBkColor (m_crBkColor);
    return (HBRUSH) m_brBkgnd;
}

/////////////////////////////////////////////////////////////////////////////
// CEditListBox message map and member functions

BEGIN_MESSAGE_MAP (CEditListBox, CListBox)
    ON_CONTROL_REFLECT (LBN_DBLCLK, OnEditItem)
    ON_MESSAGE (WM_SETFONT, OnSetFont)
END_MESSAGE_MAP ()

BOOL CEditListBox::PreCreateWindow (CREATESTRUCT& cs)
{
    if (!CListBox::PreCreateWindow (cs))
        return FALSE;

    cs.style &= ~LBS_OWNERDRAWVARIABLE;
    cs.style |= (LBS_NOTIFY | LBS_OWNERDRAWFIXED | LBS_HASSTRINGS);
    return TRUE;
}

LRESULT CEditListBox::OnSetFont (UINT wParam, LONG lParam)
{
    LRESULT lResult = Default ();

    TEXTMETRIC tm;
    CClientDC dc (this);

    CFont* pFont = CFont::FromHandle ((HFONT) wParam);
    CFont* pOldFont = dc.SelectObject (pFont);
    dc.GetTextMetrics (&tm);
    dc.SelectObject (pOldFont);

    SetItemHeight (0, tm.tmHeight);
    return lResult;
}

void CEditListBox::DrawItem (LPDRAWITEMSTRUCT lpdis)
{
    CDC dc;
    dc.Attach (lpdis->hDC);
    CRect rect = lpdis->rcItem;
    int nIndex = lpdis->itemID;

    CBrush* pBrush = new CBrush (::GetSysColor ((lpdis->itemState &
        ODS_SELECTED) ? COLOR_HIGHLIGHT : COLOR_WINDOW));

    dc.FillRect (rect, pBrush);
    delete pBrush;

    if (lpdis->itemState & ODS_FOCUS)
        dc.DrawFocusRect (rect);

    if (nIndex != (UINT) -1) {
        CString string;
        GetText (nIndex, string);

        int nMode;
        COLORREF crColor;
        if (lpdis->itemState & ODS_SELECTED) {
            crColor = dc.SetTextColor (::GetSysColor (COLOR_HIGHLIGHTTEXT));
            nMode = dc.SetBkMode (TRANSPARENT);
        }

        rect.left += 2;
        dc.DrawText (string, rect, DT_LEFT | DT_VCENTER | DT_SINGLELINE);

        if (lpdis->itemState & ODS_SELECTED) {
            dc.SetTextColor (crColor);
            dc.SetBkMode (nMode);
        }
    }
    dc.Detach ();
}

void CEditListBox::OnEditItem ()
{
    CString string;
    m_nIndex = GetCurSel ();
    GetText (m_nIndex, string);

    RECT rect;
    int nResult = GetItemRect (m_nIndex, &rect);

    CEdit* pEdit = new CLBEdit;
    pEdit->Create (WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL,
        rect, this, (UINT) -1);

    CFont* pFont = GetFont ();
    pEdit->SetFont (pFont);
    pEdit->SetWindowText (string);
    pEdit->SetFocus ();
}

void CEditListBox::UpdateItemText (CString& string)
{
    DeleteString (m_nIndex);

    int nIndex = (GetStyle () & LBS_SORT) ? AddString (string) :
        InsertString (m_nIndex, string);

    SetCurSel (nIndex);
}

/////////////////////////////////////////////////////////////////////////////
// CLBEdit message map and member functions

BEGIN_MESSAGE_MAP (CLBEdit, CEdit)
    ON_WM_CHAR ()
    ON_WM_KILLFOCUS ()
END_MESSAGE_MAP ()

void CLBEdit::OnChar (UINT nChar, UINT nRepCnt, UINT nFlags)
{
    if (nChar == VK_RETURN) {
        CString string;
        GetWindowText (string);
        ((CEditListBox*) GetParent ())->UpdateItemText (string);
        PostMessage (WM_CLOSE, 0, 0);
        return;
    }
    else if (nChar == VK_ESCAPE) {
        PostMessage (WM_CLOSE, 0, 0);
        return;
    }
    CEdit::OnChar (nChar, nRepCnt, nFlags);
}

void CLBEdit::OnKillFocus (CWnd* pNewWnd)
{
    PostMessage (WM_CLOSE, 0, 0);
}

void CLBEdit::PostNcDestroy ()
{
    delete this;
}
