@echo off

 :: Requires two parameters. See ":help" section, below.
 :: %1 is a password (case insensitive).
 :: %2 is the # of lines hidden. This batch file will hide up to
 :: 6 lines.

:paramcheck
 if %2.==. goto help

:okparam
 if %2==0 %0 %1 /c
 if %2==/c goto clear
 if %2==/C goto clear
:else
 echo.
 if %2.==1. echo Hiding 1 line of the environment table.
 if not %2.==1. echo Hiding %2 lines of the environment table.
 echo.
 set %1b=
 set %1c=
 set %1d=
 set %1e=
 set %1f=
 set %1x=
 ::
 ::
 set %1a=([80D([s([K([1A([K([u
 if %2==1 goto SetCL
 set %1b=([80D([s([K([3A([K([u
 if %2==2 goto SetCL
 set %1c=([80D([s([K([5A([K([u
 if %2==3 goto SetCL
 set %1d=([80D([s([K([7A([K([u
 if %2==4 goto SetCL
 set %1e=([80D([s([K([9A([K([u
 if %2==5 goto SetCL
 set %1f=([80D([s([K([11A([K([u
 if %2==6 goto SetCL
 ::
 :: NOTE: [80D and [K deletes the new set password from display
 ::   [#A  writes over the original variables, starting with lowest line.
 ::
 set %1x=([80D([K([13A
 echo.
 echo ERROR: Invalid Syntax: %%2 must be a # from 1 to 6, not "%2".
 echo        Six lines of the environment have been hidden 
 echo        (default for an error condition).
 echo.
 goto end

:SetCL
 :: Move the cursor back up to under the last visible
 :: environment variable.
 if %2.==1. set %1x=([80D([K([3A
 if %2.==2. set %1x=([80D([K([5A
 if %2.==3. set %1x=([80D([K([7A
 if %2.==4. set %1x=([80D([K([9A
 if %2.==5. set %1x=([80D([K([11A
 if %2.==6. set %1x=([80D([K([13A
 goto end

:clear
 set | find /i "%1A=">nul
 if errorlevel 1 goto PassWordErr
 set %1a=
 set %1b=
 set %1c=
 set %1d=
 set %1e=
 set %1f=
 set %1x=
 echo.
 echo All lines of the environment that were hidden with
 echo password "%1" are now made visible.
 echo.
 goto end

:PassWordErr
 set | find "([80D([s">nul
 if errorlevel 1 goto NotHidden!
 echo.
 if not errorlevel 1 echo The password is incorrect. Try again.
 echo.
 goto end

:NotHidden!
  echo.
  echo The environment is already visible! Nothing to clear,
  echo since nothing is hidden!
  echo.
  goto end

:help
 echo.
 echo Usage:   HIDESET Password #Lines
 echo       OR HIDESET Password /c
 echo.
 echo    Password = All ASCII characters allowed which are valid 
 echo               in a command line. Case insensitive.
 echo    #Lines   = Number of lines to hide, up to 6 lines.
 echo    /c       = Clear the hiding of all lines.
 echo.
 echo Example: HIDESET nosee 3
 echo.
 echo Purpose: Hide the environment from unsavvy but prying eyes.
 echo     Avoid detection of private environmental variables;
 echo     for example: PASSWORD=DumbBoss, TEMPDIR=D:\XRATDGIF
 echo     or LASTWORK=FighterPilotGame.
 echo.
 echo Notes: * This uses environment space. The /E:# parameter of
 echo    command.com may have to be increased in config.sys.
 echo    * Requires DOS 5.0 or later to verify the password.
 echo    * The password (%%1) is case insensitive.
 echo.

:end
