
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include "wtouprot.h"
#include "wtouwin.h"


//
//  FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)
//
//  PURPOSE: Entry point for the application.
//
//  COMMENTS:
//
//	This function initializes the application and processes the
//	message loop.
//
int APIENTRY WinMain(HINSTANCE hInstance, 
	HINSTANCE hPrevInstance, 
	LPSTR lpCmdLine, 
	int nCmdShow)
{
	CWinToUnix	WintoUnix;

	if (!hPrevInstance) 
	{
		// No previous instance
	}

	WintoUnix.CreateSocketWindow (hInstance, UNIX_NAME_ADDRESS);

	return 0;

	lpCmdLine; // This will prevent 'unused formal parameter' warnings
}


//
// Constructor
//
CWinToUnix::CWinToUnix ()
{
	wVersion = MAKEWORD(1,1);

	memset ((char *)&ServerAddr, 0, sizeof(ServerAddr));

	memset (&inAddrLocal, 0, sizeof(inAddrLocal));
	memset (&inAddrRemote, 0, sizeof(inAddrRemote));
	
	LocalName[0] = NULL;
	RemoteIPAddressStr[0] = NULL;
	HostIPAddressStr[0] = NULL;
	
	hWSAAsyncGetHostByName = 0;

	pLocalHost = pRemoteHost = NULL;
	pReadData = NULL;

	s = 0;

	iReadIndex = 0;
}


//
// Destructor
//
CWinToUnix::~CWinToUnix()
{
	CloseWinSock();

	if (pLocalHost)
		free (pLocalHost);
	if (pRemoteHost)
		free (pRemoteHost);
}


//
// CreateSocketWindow
//
int CWinToUnix::CreateSocketWindow (HINSTANCE hInstance, char* pServerName)
{
	MSG			msg;
	WNDCLASS	WndClass;
	HMODULE		hm = 0;
	int		rc;

	this->hInstance = hInstance;

	// Start Windows Sockets

	if (rc = WSAStartup (wVersion, &wsaData))
		return WSAGetLastError ();

	strcpy (ServerName, pServerName);

	// Allocate buffers for socket data

	if (!(pLocalHost = (PHOSTENT)malloc (MAXGETHOSTSTRUCT)))
		return -1;

	if (!(pReadData = (char *)malloc (NETCAST_READ_BUFFER)))
		return -1;

	// Register a window class

	memset (&WndClass, 0, sizeof(WndClass));

	WndClass.lpfnWndProc = AsyncWindowProc;
	WndClass.hInstance = hInstance;
	WndClass.lpszClassName = WINTOUNIX_WINDOW_CLASS;

	RegisterClass (&WndClass);

	// Creaate the window and show it (you can keep it invisable also)

	if (!(hWndAsync = CreateWindow (WINTOUNIX_WINDOW_CLASS, "WinToUnix", 
		WS_CAPTION | WS_POPUPWINDOW, 20, 20, 220, 20, HWND_DESKTOP, NULL, hm, 0)))
		return GetLastError();

	ShowWindow (hWndAsync, SW_SHOWNORMAL);
	UpdateWindow (hWndAsync);
 
	// Set a pointer to our object in the Window data bytes

	SetLastError (0);

	if (!(SetWindowLong (hWndAsync, GWL_USERDATA, (LONG)this)))
	{
		if (GetLastError())
			return -1;
	}

	// Post message to start connection process

	BOOL brc = PostMessage (hWndAsync, WM_REQUESTLOCALBYNAME, 0, 0);

	// Process messages until WM_QUIT

	while (GetMessage (&msg, hWndAsync, NULL, NULL))
	{
		TranslateMessage (&msg);  
		DispatchMessage (&msg);    
	}
	return 0;
}


//
// CloseWinSock 
//
int CWinToUnix::CloseWinSock () 
{
	BOOL brc;

	// Close Windows Sockets

	if (hWndAsync)
	{
		brc = PostMessage (hWndAsync, WM_DESTROY, 0, 0);
	}
	return brc ? 0 : -1;
}


//
// AsyncWindowProc 
//
LRESULT CALLBACK AsyncWindowProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int			rc;
	CWinToUnix*	pThis;
	BOOL		fNetscape = FALSE;

	switch (uMsg)
	{
	case WM_CREATE:
 		break;
	case WM_REQUESTLOCALBYNAME:
	{
		if (pThis = (CWinToUnix *)GetWindowLong (hWnd, GWL_USERDATA))
		{
			// Get Local Windows IP Address

			if (rc = gethostname (pThis->LocalName, sizeof(pThis->LocalName)))
				return WSAGetLastError ();

			pThis->hWSAAsyncGetHostByName = WSAAsyncGetHostByName (hWnd,
				WM_GETLOCALHOSTBYNAME,
				pThis->LocalName,
				(char *)pThis->pLocalHost,
				MAXGETHOSTSTRUCT);
		}
		break;
	}
	case WM_GETLOCALHOSTBYNAME:
	{
		if (pThis = (CWinToUnix *)GetWindowLong (hWnd, GWL_USERDATA))
		{
			// Get the remote IP Address

			if (!(rc = WSAGETSELECTERROR (lParam)))
			{
				if (pThis->pLocalHost)
				{
					memcpy (&pThis->inAddrLocal, pThis->pLocalHost->h_addr, sizeof(pThis->inAddrLocal));
					strcpy (pThis->HostIPAddressStr, inet_ntoa(pThis->inAddrLocal));

					if (!(pThis->pRemoteHost = (PHOSTENT) malloc (MAXGETHOSTSTRUCT)))
						return -1;

					pThis->hWSAAsyncGetHostByName = WSAAsyncGetHostByName (hWnd,
						WM_GETREMOTEHOSTBYNAME,
						pThis->ServerName,
						(char *)pThis->pRemoteHost,
						MAXGETHOSTSTRUCT);
				}
			}
			else
			{
				// Try it again...

				Sleep(0);
				BOOL brc = PostMessage (pThis->hWndAsync, WM_REQUESTLOCALBYNAME, 0, 0);
			}
		}
		break;
	}
	case WM_GETREMOTEHOSTBYNAME:
	{
		if (pThis = (CWinToUnix *)GetWindowLong (hWnd, GWL_USERDATA))
		{
			if (!(rc = WSAGETSELECTERROR (lParam)))
			{
				if (pThis->pRemoteHost)
				{
					memcpy (&pThis->inAddrRemote, pThis->pRemoteHost->h_addr, sizeof(pThis->inAddrRemote));
					strcpy (pThis->RemoteIPAddressStr, inet_ntoa(pThis->inAddrRemote));

					pThis->hWSAAsyncGetHostByName = 0;

					// Make a connection

					rc = pThis->MakeServerConnection (hWnd);
				}
			}
		}
		break;
	}
	case WM_ASYNCIONOTIFY:
	{
		// Notifys come in for both connect and read events

		if (pThis = (CWinToUnix *)GetWindowLong (hWnd, GWL_USERDATA))
		{
			if (!WSAGETSELECTERROR (lParam))
			{
				// No error

				switch (WSAGETSELECTEVENT (lParam))
				{
				case FD_CONNECT:
				{
					// Connect event

					WSAAsyncSelect (pThis->s, hWnd, WM_ASYNCIONOTIFY, FD_READ);

					LOGIN	Login;

					Login.usType = htons (CLIENT_LOGIN);
					Login.usLen = htons (sizeof(LOGIN));
					Login.ulUserID = htonl(1);
					Login.ulFlags = 0;

					int sent = pThis->sendn (pThis->s, (char *)&Login, sizeof(LOGIN));

					break;
				}
				case FD_READ:
				{
					// Read event

					pThis->ReadServerData ();
					break;
				}
				}
			}
		}
		break;
	}
	case WM_DESTROY:
	{
		if (pThis = (CWinToUnix *)GetWindowLong (hWnd, GWL_USERDATA))
		{
			if (pThis->hWSAAsyncGetHostByName)
			{
				rc = WSACancelAsyncRequest (pThis->hWSAAsyncGetHostByName); 
 			}

			pThis->hWndAsync = 0;

			// Close Windows Sockets

			if (pThis->s)
				rc = closesocket (pThis->s);

 			rc = WSACleanup();

			PostQuitMessage (0);
		}
		break;
	}

	default:
		return DefWindowProc (hWnd, uMsg, wParam, lParam);
	}
	return 0;
}


//
// MakeServerConnection 
//
int CWinToUnix::MakeServerConnection (HWND hWnd) 
{
	int			rc;
	
	// Open and Bind a Socket

	if ((s = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)
		return WSAGetLastError ();

	ServerAddr.sin_family = AF_INET;
    ServerAddr.sin_addr.s_addr = htonl(INADDR_ANY);		// Will take any IP
    ServerAddr.sin_port = 0;				

	if (bind (s, (struct sockaddr *)&ServerAddr, sizeof(ServerAddr)))
	{
		rc = WSAGetLastError ();

		closesocket (s);
		return rc;
	}

	if (WSAAsyncSelect(s, hWnd, WM_ASYNCIONOTIFY, FD_CONNECT) < 0)
	{
		rc = WSAGetLastError ();

		closesocket (s);
		return rc;
	}

	// Connect to Remote Host

	ServerAddr.sin_family = AF_INET;
    ServerAddr.sin_addr.S_un.S_un_b.s_b1 = pRemoteHost->h_addr[0];
    ServerAddr.sin_addr.S_un.S_un_b.s_b2 = pRemoteHost->h_addr[1];
    ServerAddr.sin_addr.S_un.S_un_b.s_b3 = pRemoteHost->h_addr[2];
    ServerAddr.sin_addr.S_un.S_un_b.s_b4 = pRemoteHost->h_addr[3];
    ServerAddr.sin_port = htons(SERV_TCP_PORT);

	if ((rc = connect (s, (struct sockaddr *)&ServerAddr, sizeof(ServerAddr))) < 0)
	{
		rc = WSAGetLastError ();

		if (rc != WSAEWOULDBLOCK)
		{
			closesocket (s);
			return rc;
		}
	}
	return 0;
}


//
// ReadServerData 
//
int CWinToUnix::ReadServerData () 
{
	int			iReadCount;
	int			iReadSize = sizeof(GENERIC);
	GENERIC*	pGen = (GENERIC *)pReadData;

	if (iReadIndex)
		iReadSize = pGen->usLen - iReadIndex;

	iReadCount = recv (s, pReadData + iReadIndex, iReadSize, 0);

	if (iReadCount < 0)
	{
		return WSAGetLastError ();
	}
	else if (!iReadCount)
	{
		// Connection was closed

		return -1;
	}
	else if (!iReadIndex)
	{
		// First read...just swap generic packet

		pGen->usType = ntohs (pGen->usType);
		pGen->usLen = ntohs (pGen->usLen);

		iReadIndex = sizeof(GENERIC);
	}
	else if (iReadCount >= iReadSize)
	{
		// Last read...packet complete...reset index and process message

		iReadIndex = 0;

		ProcessMessage (pGen);
	}
	else
	{
		// Packet not complete...increment index by ReadCount. 

		iReadIndex += iReadCount;
	}
	return 0;
}


//
// ProcessMessage 
//
int CWinToUnix::ProcessMessage (GENERIC* pGen) 
{
	switch (pGen->usType)
	{
	case SERVER_LOGIN_ACK:
		// Do Whatever
		break;
	default:
		break;
	}
	return 0;
}



/**********************************************

UTILITIES

***********************************************/
//
// sendn
//
int CWinToUnix::sendn (SOCKET socket, char *ptr, int nbytes)
{
	int	nleft, nwritten;

	nleft = nbytes;

	while (nleft > 0)
	{
		nwritten = send (socket, ptr, nbytes, 0);

		if (nwritten <= 0)			/* error */
		{
			return nwritten;
		}

		nleft -= nwritten;
		ptr += nwritten;
	}
	return (nbytes - nleft);
}









