; pentbug.asm
;
; tests for the existence of the well-documented Pentium NPU bug
;
; According to an Intel document, dated 1 December 1994, there's a known
; bug in the Pentium's floating point unit.  The bug only manifests
; itself on certain pairs of floating point numbers, and only when
; they're divided.  They say that the flaw is due to a problem with the
; lookup table used by the iterative algorithm of the values for which
; this flaw occurs.  Intel claims that most users will be unaffected.
;
; written on Fri  12-02-1994  by Ed Beroset
; and released to the public domain by the author
;
; assemble and run this program using Borland's TASM and run under DOS:
;
;   TASM pentbug                ; one pass assemble
;   TLINK /Tdc pentbug          ; link as COM file
;   PENTBUG                     ; run the program...
;
        IDEAL
        MODEL tiny
        p386
        p387

        CODESEG
        ORG     100h
Start:
        mov     dx,OFFSET okmsg         ; start out optimistically
        fild    [first]                 ; load the first number (x)
        fild    [second]                ; and the second (y)
        fdiv    st(1),st                ; perform y/x
        fmulp   st(1),st                ; now st(0) = (y/x)*x
        fild    [first]                 ; reload y
        fcompp                          ; compare the two
        fnstsw   ax                     ; put status word into ax
        sahf                            ; load into CPU flags
        jz      short @@NoBug           ; if they're equal, no bug
        mov     dx,OFFSET bugmsg        ; load bad news message...
@@NoBug:
        mov     ah,9                    ; print appropriate message
        int     21h                     ;
        mov     ah,4ch                  ; and exit
        int     21h                     ;

first   DD  4195835                     ; "magic numbers" culled from
second  DD  3145727                     ; the net.  There are others...

okmsg   DB  "No "
bugmsg  DB  "Pentium bug found.",13,10,'$'

        END Start

