;-------------------------------
; pm2real.asm by Scott Pitcher
comment */

The shutdown vector is used for switching the CPU from protected to real
mode. You set the CMOS register and the BIOS entry vector to regain
control afterwards, then generate a double fault with a NULL IDT - you
can use any instruction sequence that will force the CPU to shutdown.
This also works on 80386 CPUs and above. Some older 80286 BIOSs
apparently do silly things like reset the keyboard shift status etc, so
you may have to save these across the switch. Also, the BIOS will set up
a stack (my AMI was at 030:0100h) so you may also have to save the
vectors at the end of the table if you don't want them trashed. Another
method is to write 04h into the CMOS shutdown status byte and hook
interrupt 19h which does the same thing. However, I don't think all BIOS
ROMs support this. It worked on my old AMI BIOS but not on a friends
PS/1. The switch takes something like 30h to 50h cycles of the clocks
(not clock ticks - cycles) depending on the CPU. My 80386dx40 actually
takes about twice as long to return as my old 80286-16 did!

The code ...
/*

;------------------------------------------------------------------
;   void Switch286ToRealMode(void);
;
;   Switch the 80286 processor from protected mode to real mode. The
;   call assumes that interrupts are already disabled as it is not
;   re-entrant. Disable interrupts via the 8259s not the CPU interrupt
;   flag.
;
;   Entry:
;       CS,DS   = DPMIHOST_TEXT selector
;       SS:SP   = DPMIHOST_TEXT internal stack
;       interrupts disabled
;   Exit:
;       CS,DS   = DPMIHOST_TEXT real mode segment
;       SS:SP   = DPMIHOST_TEXT internal stack
;       interrupts disabled
;
_Switch286ToRealMode    proc near
    public _Switch286ToRealMode
.286P
;
    push    bp
    mov     bp,sp
    pusha                       ;save all registers across the call
;                               ;place reentry vector in the
                                ;BIOS data area
    mov     es,[_pmBiosData]    ;pm alias for segment 040h
    mov     word ptr es:[67h],offset @@RealEntry
    mov     ax,[_rmCsAlias]
    mov     word ptr es:[69h],ax
;
    mov     ax,0fh
    out     70h,al
    xchg    al,ah
    in      al,71h              ;get current shut down status byte
    push    ax                  ;save it on the stack
    mov     al,5
    out     71h,al              ;enter new shut down status byte
;
    mov     [_spTemp],sp        ;save sp across shutdown
;
    lidt    [_nullIdt]          ;nul descriptor table
    int     0                   ;generate an exception (shutdown)
    hlt                         ;just in case!
;
@@RealEntry:                    ;back in real mode now!
    mov     ax,cs               ;set real mode segment registers
    mov     ds,ax
    mov     ss,ax
    mov     sp,[_spTemp]        ;restore stack pointer
;
    pop     ax
    xchg    al,ah
    out     70h,al
    xchg    al,ah
    out     71h,al              ;restore the shut down status byte
;
    popa
    pop     bp
    ret
.8086
;
_Switch286ToRealMode    endp
;
;---------------------------------------------------------------
