;UTILS.INC
;

;character codes
BELL        equ 7
CR          equ 13
LF          equ 10
SPACE       equ 20h

;PSP offsets
pspENVSEG   equ 2ch     ;offset of environment segment in PSP
pspPARENT   equ 16h     ;parent PSP
pspTERMINATE equ 0Ah    ;termination address

MACRO ToUpper
    LOCAL @@M1
    cmp al, 'a'
    jb @@M1
    cmp al, 'z'
    ja @@M1
    and al, NOT 20h
@@M1:
ENDM

MACRO TrashRegs
;; for debugging
  mov ax, 0FEDCh
  mov bx, ax
  mov cx, ax
  mov dx, ax
  mov si, ax
  mov di, ax
  mov es, ax
  mov ds, ax
  mov bp, ax
ENDM

MACRO UpStr
    LOCAL @@M1, @@M2
;;Convert cx chars at ds:si to upper case
    cmp cx, 0
    je @@M2

@@M1:
    mov al, [si]
    ToUpper
    mov [si], al
    inc si
    loop @@M1
@@M2:
ENDM

MACRO Write msg
  mov dx, offset msg
  mov ah, 9
  int 21h
ENDM
