;------------------------------------------------------------------------------
; subroutine to display a string terminated with a zero
;  inputs ds:si point at string
;        DISPLAY_ATTRIBUTE db 70h ;default = reverse video
;        DISPLAY_ADDRESS label
;          DISPLAY_OFFSET	dw 0 ;offset of our window
;          DISPLAY_SEGMENT dw 0  ;display segment
;  outputs ds:si point at end of string
;
display_string_d:
	cld
	les	di,DISPLAY_ADDRESS
	mov	ah,DISPLAY_ATTRIBUTE
mono_string_loop:
	lodsb         			;get next char.
	or	al,al			;check for zero
	jz	mono_text_exit		;jump if end found
	stosw        			;move one char. to display
	jmp	short mono_string_loop	;jump if end not found yet
mono_text_exit:
	ret
;============================================================================
display_char:	push	bx
		push	ax
		mov	ah,0eh			;tty display
		mov	bh,0			;page
		int	10h
		pop	ax
		pop	bx
		ret				
;=============================================================================
; inputs es:bx point at string
;           cx is max display count
;
display_string:
	mov	al,es:[bx]			;get next char
	cmp	al,0
	jz	display_string_exit		;exit if done
	call	display_char
	inc	bx
	loop	display_string
display_string_exit:
	ret
;=============================================================================
; inputs  none
;
display_crlf:
	mov	dx,offset crlf
	mov	ah,9
	int	21h
	ret
;=============================================================================
;  input cx=space count
;
display_spaces:
	mov	al,' '
display_repeat:
	call	display_char
	loop	display_repeat
	ret
;-------------------------------------------------------------------------
; display_string - display string of characters
;   INPUTS -ds:si = pointer to string (terminated with 0
;              dx = starting display address
;              bl = attribute
;   output dx - points at next display point
;
local_attribute	db	0

display_string_at_posn:
	push	si
	mov	cs:local_attribute,bl
display_loop1:
	mov	bh,0			;get page 0 code
	mov	ah,2			;set cursor position code
	push	si
	int	10h			;position the cursor
	pop	si
	mov	cx,1			;set replication count = 0
	mov	al,[si]			;get character
	or	al,al
	jz	display_string_exit	;jump if end of sting
	cmp	al,0dh			;check if cr
	jne	clf			;  jmp if not
	mov	dl,0
	jmp	display_loop2
clf:	cmp	al,0ah
	jne	char_out
	inc	dh
	jmp	display_loop2
char_out:
	mov	ah,9			;display char. code
	mov	bl,cs:local_attribute
	push	si
	int	10h			;display char.
	pop	si
	inc	dx
display_loop2:
	inc	si
	jmp	display_loop1		;loop till done
;
; hide the cursor again
;
display_string_exit:
	push	dx
	mov	ah,2			;get position code
	mov	bh,0			;page
	mov	dx,1900h		;row 26 column 0
	int	10h
	pop	dx
	pop	si
	ret
;-------------------------------------------------------------------------
; display list
;   inputs  ds:si = list pointer
;
display_list:
	mov	dx,0			;start display at line 0
list_loop:
	push	si
	mov	si,[si]			;get list entry
	cmp	si,0
	je	list_end		;jmp if all done
	mov	bl,attribute
	call	display_string_at_posn
	pop	si
	add	si,2
	jmp	list_loop		;loop till done
list_end:
	pop	si
	ret	
;----------------------------------------------------------------------------
