;
;       This module tells if drive A or B should be accessed.
;

        PUBLIC          _drive_ab_present
_drive_ab_present       PROC FAR
        push    bp
        mov     bp,sp
        push    es
        push    bx
        push    cx
        int     11h
        test    al,1                    ; floppies present?
        jz      dab_exit_1              ; no so always report 'go for it'
        mov     cl,6
        shr     al,cl
        and     al,3                    ; al==nbr drives per BIOS-1
        inc     al                      ; al==nbr drives per BIOS
        cmp     al,1                    ; if drives!=1, report 'go for it'
        jne     dab_exit_1              ; if don't branch, 1 floppy present
        mov     bx,[bp+6]               ; bx=input arg from caller
        xor     ax,ax                   ; al=0
        or      bx,bx                   ; input arg is 0?
        jz      dab_wants_a             ; yes, 0, so drive desired is 0
        inc     ax                      ; al=1
dab_wants_a:
                                        ; now al 0 if checking A, 0FFh if
                                        ; user is checking B
        xor     bx,bx
        mov     es,bx
        mov     bx,504h
        mov     ah,es:[bx]              ; get DOS a_b floppy var
                                        ; now ah 0 if real drive is now
                                        ; acting as A, 1 if B

;       now we test AH against AL.  if AH==AL, user wants to know
;       about the drive that IS present.  If AH!=AL, user is
;       checking the phantom drive.

        cmp     al,ah
        je      dab_exit_1              ; equal, so present
                                        ; otherwise fall through, not present
dab_exit_0:
        xor     ax,ax
        jmp     SHORT dab_quit
dab_exit_1:
        mov     ax,1
dab_quit:
        pop     cx
        pop     bx
        pop     es
        pop     bp
        ret
_drive_ab_present       ENDP
