PAGE 60,132
TITLE DTEST 1.2 - A DISKETTE DRIVE TEST PROGRAM.
;
;  Written by:  Richard L. Fink
;               RainTree Computer Systems
;               P.O.Box 2339
;               Mill Valley, CA 94941
;
;  Date:        June 11, 1991
;  Compiler:    MASM 6.0
;
;  License:     DTEST.COM and it's assembler source file are hereby
;               placed in the Public Domain.
;
;
;  DTEST.COM program which is run from the command line or a batch file.
;  It tests a diskette drive to see whether or not it contains a diskette.
;  If a diskette is detected, DTEST will determine which of the following
;  states it is in: unformatted, formatted with no files, formatted with
;  files.  A unique DOS Errorlevel is returned for each condition.
;
;  This is invaluable for preventing the dreaded:
;                    ABORT, RETRY, IGNORE?
;  in the operation of a batch file.
;
;  DTEST.COM is run by just typing the name DTEST, followed by a drive
;  letter in upper or lower case:
;                    DTEST B
;  If no drive is provided, the default is the A drive.  Note that no
;  validation is performed on the drive character.  An invalid drive will
;  return that the drive contains an unformatted diskette.
;
;  Returned DOS Errorlevel:
;        0 - Drive contains a formatted diskette which is EMPTY.
;        1 - Drive contains a formatted diskette with files or directories.
;        2 - Drive contains an UNFORMATTED diskette.
;        3 - Drive does NOT contain a diskette.
;        4 - Drive is an unknown unit.
;
;  -------------------------------------------------------------------------
;  The idea for DTEST came from a DOS Tip by Dan Gookin in the April 1991
;  issue of PC Computing Magazine.
;
PAGE
;
DTEST_SEG   SEGMENT BYTE PUBLIC
            ASSUME  CS:DTEST_SEG,DS:DTEST_SEG
            ORG     100H
;
;
DTEST       PROC    FAR
            MOV     BX,80H             ;GET PTR TO PARM LENGTH IN PSP.
            ADD     BL,[BX]            ;GET PTR TO END OF PARM TAIL.
            MOV     AL,[BX]            ;GET PARM FROM FIELD.
;
            AND     AL,NOT 20H         ;CONVERT TO UPPER CASE.
            JZ      @F                 ;NO PARM, USE DEFAULT.
            MOV     DRIVENO,AL         ;SAVE IT.
@@:
;                            ;ABSOLUTE DISK READ.
            MOV     DX,0               ;LOGICAL SECTOR NO.
            MOV     CX,1               ;NUMBER OF SECTORS TO READ.
            MOV     BX,OFFSET DTA      ;PTR TO DTA.
            MOV     AL,DRIVENO         ;GET DRIVE CAHARACTER.
            SUB     AL,41H             ;CONVERT ASCII DRIVE CHAR TO A DRIVE NUMBER.
            INT     25H                ;ABSOLUTE DISK READ.
            POP     DX                 ;DISCARD FLAGS LEFT ON THE STACK BY INT-25.
            JC      BAD_READ           ;DRIVE DOES NOT CONTAIN A FORMATTED DISKETTE.
;
;                            ;DISKETTE IS FORMATTED-  CHECK FOR FILES.
            PUSH    DS                 ;SAVE DATA SEG.
            MOV     AH,2FH             ;GET DTA, ES:BX RETURNED.
            INT     21H                ;DOS FUNCTION CALL.
            PUSH    BX                 ;SAVE OFFSET TO FOX DTA.
            PUSH    ES                 ;SAVE BASE   TO FOX DTA.
;
            MOV     DX,OFFSET DTA      ;PT TO LOCAL DTA.
            MOV     AH,1AH             ;SET DTA, TO DS:DX.
            INT     21H                ;DOS FUNCTION CALL.
;
            MOV     DX,OFFSET DRIVENO  ;PT TO DRIVE,PATH,FILENAME STRING.
            MOV     CX,017H            ;ATTRIBUTE.
            MOV     AH,4EH             ;FIND 1ST FILENAME MATCH, @DS:DX.
            INT     21H                ;DOS FUNCTION CALL.
;
PAGE
;
            POP     DS                 ;GET BASE   TO FOX DTA.
            POP     DX                 ;GET OFFSET TO FOX DTA.
            PUSHF                      ;SAVE SYSTEM STATUS FROM FILE FIND.
            MOV     AH,1AH             ;SET DTA, TO DS:DX.
            INT     21H                ;DOS FUNCTION CALL.
            POPF                       ;RESTORE SYSTEM STATUS FROM FILE FIND.
            POP     DS                 ;RESTORE DATA SEG.
;
            MOV     DL,0               ;SETUP BASE RETURN CODE.
            JC      RTNCD_0            ;DISKETTE HAS NO FILES.
            JMP     RTNCD_1            ;DISKETTE HAS FILES.
;
;
BAD_READ:                    ;DRIVE CONTAINS NO DISKETTE, OR UNFORMATTED DISKETTE.
            MOV     DL,0               ;SETUP BASE RETURN CODE.
            CMP     AH,1FH             ;READ ERROR-  DRIVE FAILED TO RESPOND ?
            JAE     RTNCD_3            ;YES.
            CMP     AH,8               ;READ ERROR-  BAD CRC ?
            JE      RTNCD_2            ;YES.
            CMP     AX,0201H           ;READ ERROR-  UNKNOWN UNIT ?
            JE      RTNCD_4            ;YES.
            JMP     RTNCD_2            ;OTHER READ ERROR.
;
;
RTNCD_4:    INC     DL                 ;RTN CODE 4 - Drive is an unknown unit.
RTNCD_3:    INC     DL                 ;RTN CODE 3 - Drive does NOT contain a diskette.
RTNCD_2:    INC     DL                 ;RTN CODE 2 - Drive contains an UNFORMATTED diskette.
RTNCD_1:    INC     DL                 ;RTN CODE 1 - Drive contains a formatted diskette with files.
RTNCD_0:                               ;RTN CODE 0 - Drive contains a formatted diskette with no files.
;
            MOV     AL,DL              ;SETUP RETURN CODE.
            MOV     AH,4CH             ;SETUP TERMINATE.
            INT     21H                ;TERMINATE PROGRAM, WITH RETURN CODE.
DTEST       ENDP
;
DRIVENO     DB      41H,':\*.*',0      ;DRIVE, PATH, FILENAME, ASCIIZ STRING.
DTA         DB      512 DUP(?)         ;DTA-  SIZE = 1 SECTOR.
;
DTEST_SEG   ENDS
            END     DTEST
