;-----------------------------------------------------------------------------
;--------------------------------  TIME.ASM  ---------------------------------
;-----------------------------------------------------------------------------
	.MODEL	SMALL
	.CODE
;----------------------------------
; delay using the timer
;  inputs  dh = seconds to delay
;          dl = hunderedths of a second
;  oututs  al = 0 if no error
;
	public	delay
delay	proc
	push	bx
	push	cx
	push	dx
	cmp	dh,59
	ja	toohigh
	cmp	dl,99
	jbe	saveins
toohigh:mov	al,0ffh
	jmp	leave		;exit if error
saveins:mov	bx,dx		;save delay in -bx-
	mov	ah,2ch		;get time
	int	21h		;  in cx,dx  dh=sec  dl=hundredths
	mov	ax,cx		;     ax = hours,minutes
	add	bl,dl		;compute target
	cmp	bl,100		;  hundredths
	jb	sect		;    in -bl-
	sub	bl,100		;  
	inc	bh
sect:	add	bh,dh		;compute target
	cmp	bh,60		;  seconds
	jb	mint		;    in -bh-
	sub	bh,60
	inc	al
mint:	cmp	al,60		;compute minutes
	jb	hrt		;     in -al-
	sub	al,60
	inc	ah
hrt:	cmp	ah,24		;compute hour
	jb	wait1		;     in -ah-
	sub	ah,24
wait1:	push	ax
	mov	ah,2ch
	int	21h
	pop	ax
	cmp	ch,ah		;compare target hour
	jne	wait1		; and jump if no match
	cmp	cl,al		;compare target minutes
	jb	wait1		; and jump if no match
	ja	clral
	cmp	dx,bx		;check seconds and hundredths
	jb	wait1
clral:	mov	al,0
leave:	pop	dx
	pop	cx
	pop	bx
	ret
delay	endp



	; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	;		These routines manage the TIMER function.  
	; They start, stop, and display the elapsed time of some disk action.

Time_Start:
	push	ax
	push	bx
	push	cx
	push	dx
	mov	ah,2Ch		;get the time
	int	DOS		;CH=hrs, CL=min, DH=sec, DL=1/100sec
	mov	dx,0001		;clear the seconds, the hundredths,
	mov	cl,00		;...and the minutes
	mov	ah,2Dh		;send time to system
	int	DOS		;and reset the system timer
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	Ret

Time_Stop:
	push	ax
	push	bx
	push	cx
	push	dx
	mov	ah,2Ch		;get the time
	int	DOS		;CH=hrs, CL=min, DH=sec, DL=1/100sec
	mov	num_seconds,DH
	mov	num_100ths,DL
	mov	num_minutes,CL
;	  mov	ax,100		; Seconds times 100...
;	  mul	num_seconds	; are now in AX.  This is good to 32 sec
;	  mov	dh,00
;	  add	ax,dx		;add in the 100ths of a second for a max of 32000 100ths
;	  mov	num_time,ax	;and save for later use
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	Ret

Time_Display:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	mov	al,num_minutes
	cmp	al,0			;don't say MINUTES, if there aren't any
	je	no_mins
	call	al2dec
	call	crt
	mov	dx,offset msg_min
	call	crt
no_mins:
	mov	al,num_seconds
	call	al2dec			;say how many seconds
	call	crt
	mov	dx,offset msg_sec
	call	crt
	mov	al,num_100ths
	call	al2dec			;say how many 100ths
	cmp	al,1			;were there more than 1 digits?
	jg	sec_ok			;yes, no problem
	dec	dx			;point previous char position
	mov	si,dx
	mov	al,leading0
	mov	[si],al			;write the leading zero
sec_ok:
	call	crt
	mov	dx,offset msg_100ths
	call	crt
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	Ret

