; Square root method 1
;  input:  ax = radicand
;  output: dl = root
;          ax = remainder
;
root:	xor	dx,dx
	mov	bx,4000h
	mov	cx,8
rt1:	sub	ax,dx
	sub	ax,bx
	js	rt_negative
	shr	dx,1
	or	dx,bx
	jmp	loop_tail
rt_negative:
	add	ax,dx
	add	ax,bx
	shr	dx,1
loop_tail:
     	shr	bx,1
	shr	bx,1
	loop	rt1
	ret
	
;-------------------------------------------------------------
;----------------------------------------------------------------
;INTEGER SQUARE ROOT
;  CALL WITH    AX = ARGUMENT
;  RETURN       AX = SQUARE ROOT
;
SQ_ROOT PROC
SQRT:
        PUSH BX
        PUSH CX
        PUSH DX
        MOV  DX,AX     ;ARGUMENT INTO DX
        MOV  CX,8      ;NUMBER OF ITERATIONS
        XOR  BX,BX     ;CLEAR THE REMAINDER
        MOV  AX,BX     ;CLEAR TRIAL VALUE AND FINAL RESULT STORE

SQRT1:
        SHL  BX,1      ;DOUBLE PARTIAL RESULT
        INC  BX        ;GUESS NEXT BIT IS A 1
        SHL  DX,1      ;FETCH 2 NEW BITS
        RCL  AX,1      ; FROM ARGUMENT
        SHL  DX,1
        RCL  AX,1
        SUB  AX,BX     ;DO A TRIAL SUBTRACTION
        JNC  SQRT2     ;GUESS WAS RIGHT
                       ; APPEND A 1 BIT
        ADD  AX,BX     ;GUESS WAS WRONG, PUT IT BACK
        DEC  BX        ;AND CLEAN UP FOR NEXT PASS
        LOOP SQRT1
        JMP  SQRT3     ;GO SCALE RESULT
SQRT2: 
        INC  BX        ;CONVERT xxxx01 to
                       ;xxxx10, i.e. append a 1 bit
        loop sqrt1
SQRT3:
        SAR  BX,1      ;DIVIDE BY 2 TO GET
                       ;ACTUAL SQUARE ROOT
        MOV  AX,BX     ;RETURN RESULT IN AX

        POP  DX
        POP  CX
        POP  BX
        
        RET            ;RETURN TO CALLER

SQ_ROOT ENDP
