;**********************  ASC2BIN  ************************** 
;-----------------------------------------------------------------------------
; ASC2BIN Converts an ASCII number pointed to by SI to a BIN value.
;   Entry: SI = pointer to ASCII number
;   Exit:  AX = binary value
;          CF set on error
;-----------------------------------------------------------------------------
ten             dw      10
 
asc2BIN         proc near
                xor     ax,ax                   ;Clear accumulator
                xor     bx,bx                   ;Clear BX
asc_loop:
                mov     bl,[si]                 ;Get ASCII character
                cmp     bl,13                   ;Done if carriage return or
                je      asc_exit                ;  space encountered
                cmp     bl,32
                je      asc_exit
                inc     si
                sub     bl,"0"                  ;ASCII --> binary
                jb      asc_error               ;Error if binary value is
                cmp     bl,9                    ;  less than 0 or greater
                ja      asc_error               ;  than 9
                mul     ten                     ;Multiply accumulator by 10
                add     ax,bx                   ;Add last digit to sum
                jmp     short asc_loop          ;Loop until done
asc_exit:
                clc
asc_exit1:
                ret
asc_error:
                stc
                jmp     short asc_exit1
asc2bin         endp

;----------------------------------------------------------------------;
; INPUT:  SI points to parameter start; CX = parameter length; BX = 0. ;
; OUTPUT: BX = number; CY = 0 if valid entry; CY = 1 if invalid entry. ;
;----------------------------------------------------------------------;
DECIMAL_INPUT  PROC    NEAR
NEXT_DECIMAL:  LODSB                           ;Get a character.
               SUB     AL,"0"                  ;ASCII to binary.
               JC      LOOP_DECIMAL            ;If not between 0 and 9, skip.
               CMP     AL,9
               JA      LOOP_DECIMAL
               CBW                             ;Convert to word.
               XCHG    AX,BX                   ;Swap old and new number.
               PUSH    CX                      ;Preserve counter.
               MOV     CX,10                   ;Shift to left by multiplying
               MUL     CX                      ; last entry by ten.
               POP     CX                      ;Retrieve counter.
               JC      END_DECIMAL             ;If carry, too big.
               ADD     BX,AX                   ;Add new number and store in BX.
               JC      END_DECIMAL             ;If carry, too big.
LOOP_DECIMAL:  LOOP    NEXT_DECIMAL
               CLC
END_DECIMAL:   RET
DECIMAL_INPUT  ENDP
;-----------------------------------------------------------------------------
; convert ascii string to binary
;  inputs  ds:si points at key buffer in Dos function 0a format
;          base
;  output  dx,ax = binary value
;             si = updated to point at end of value
;          carry set if error
;
ab_high	dw	0			;high binary (dx)
ab_low	dw	0			;low binary (ax)

ascii_to_binary:
	push	di
	push	bx
	mov	cs:ab_high,0			;clear
	mov	cs:ab_low,0			;  accumulators
	
	mov	bx,10			;base 10?
;	cmp	base,0
;	je	ab1			;jmp if decimal base
;	mov	bx,16			;base 16
ab1:
	mov	ch,0
	jmp	ab2
ab_loop:
	inc	si			;move to next char
ab2:	mov	al,[si]
;
; convert key to binary
;
key21:	cmp	al,0dh
	je	ab_done
	cmp	al,'k'
	je	ab_done1
	cmp	al,'K'
	je	ab_done1
	cmp	al,' '
	je	ab_done
	cmp	al,09
	je	ab_done
	cmp	al,'/'
	je	ab_done
key22:	cmp	al,'0'
	jl	ab_err			;skip non numeric key
	cmp	al,'9'
	jle	decimal			;jump if decimal value
;
; we have a hex number or bad value.
;
	cmp	al,'f'
	jg	ab_err			;skip non numeric key
	cmp	al,'F'
	jle	lower_case		;jump if lower case hex
	cmp	al,'a'
	jb	ab_err			;jmp if not hex number
	sub	al,20h			;convert to lower case hex
lower_case:
	cmp	al,'A'
	jb	ab_err			;jmp if error
	sub	al,'A'			;convert to number 0-4
	add	al,10			;compute hex value
	cmp	al,bl			;verify number matches base
	jae	ab_err			; jmp if wrong base
	jmp	got_binary_key		;
decimal:
	sub	al,'0'			;convert to number
got_binary_key:
	sub	ah,ah
	push	ax			;save key
;
; multiply sum by current base
;
	mov	ax,cs:ab_low
	mov	dx,cs:ab_high
	mul	bx
;
; add latest character to sum
;
	pop	di
	add	ax,di			;add to sum
	mov	di,0
	adc	dx,di			;add carry
;
	mov	cs:ab_low,ax
	mov	cs:ab_high,dx
	jmp	ab_loop
ab_done:
	mov	ax,cs:ab_low
	mov	dx,cs:ab_high
	clc
	jmp	ab_exit
ab_done1:
	inc	si			;skip over -k-
	jmp	ab_done
ab_err:
	stc
	jmp	ab_exit
ab_exit:
	pop	bx
	pop	di
	ret

  
;==========================================================================
;  inputs:  ds:si - points at ascii string ending with 0-2fh , 3ah-0ffh
;  output:  dx,ax - binary value
;
;  registers destroyed:  ax,bx,dx
;  
dascii_to_binary:xor	cx,cx			;clear sum
		xor	bx,bx			;   bx,cx
		xor	dx,dx
datb_loop:	lodsb				;get next char
		sub	al,30h			; '0'
		jc	datb_exit		;jmp if 0-2fh (end of string)
		cmp	al,9
		ja	datb_exit		;jmp if 3ah-0ffh (end of string)
		cbw
		push	ax
;
; multiply by ten
;
		mov	ax,bx
		mov	di,dx

		add	bx,bx
		adc	dx,dx

		add	bx,bx
		adc	dx,dx

		add	bx,ax
		adc	dx,di

		add	bx,bx
		adc	dx,dx

		pop	ax
		add	bx,ax
		adc	dx,0
		jmp	short datb_loop
		
datb_exit:	mov	ax,bx			;result to dx,ax
		ret
  

  
;==========================================================================
;  inputs:  ds:si - points at ascii string ending with 0-2fh , 3ah-0ffh
;  output:  ax    - binary value
;
;  registers destryed:  ax,bx,dx
;  
ten		dw	10

ascii_to_binary:xor	bx,bx			;clear sum
atb_loop:	lodsb				;get next char
		sub	al,30h			; '0'
		jc	atb_exit		;jmp if 0-2fh (end of string)
		cmp	al,9
		ja	atb_exit		;jmp if 3ah-0ffh (end of string)
		cbw
		xchg	ax,bx
		mul	cs:ten			;mul sum * 10
		add	bx,ax			;add current char. value
		jmp	short atb_loop
		
atb_exit:	mov	ax,bx
		ret
  
