; Life simulator, 76 bytes  - Vladislav Kaipetsky and Tenie Remmel

; If no args, regs on startup are:

; AX = BX = 0000h
; SI = IP = 0100h
; DI = SP = FFFEh

Ideal
Model Tiny
P386
CodeSeg
Org 100h

Start:      mov al,13h              ;Set mode 13h
            int 10h

            mov ds,ax               ;Seed RNG with clock
            mov ax,[033Ch]

            push 09000h             ;DS = last 64K segment
            pop ds
            push 0A000h             ;ES = video memory
            pop es
                                    ;BX is already zero
RandLoop:   add ax,ax               ;Generate random number
            setc [bx]
            jnc RandSkip
            xor al,45
RandSkip:   dec bx
            jnz RandLoop

;We do not need setup code here.  CX will be zero for all but the first
;pass, and SI starts at 0100h, DI at FFFEh:  SI - DI = 258.   Note that
;this will not run under a debugger.

LifeLoop:   mov bl,3                ;Set up for AccLoop
AccLoop:    add al,[di+bx-64]       ;Add in this column
            add al,[si+bx-2]
            add al,[si+bx+318]
            dec bx                  ;Loop back
            jnz AccLoop

            sub al,[si]             ;Adjust for center cell
            or al,[si]
            aaa                     ;instead of AND AL,0Fh
                                    ;by Vladislav Kaipetsky

            shr [byte di-64],6      ;Shift previous value
            cmp al,3                ;3 = turns on
            mov al,40h              ;40h is OR value
            jne LifeSkip
            or [byte si],al         ;Set new value

LifeSkip:   movsb                   ;Set pixel
            loop LifeLoop           ;Loop back

            mov ah,1                ;Check for key
            int 16h
            jz LifeLoop             ;Loop if no key

            mov ax,3                ;Set text mode
            int 10h
            ret                     ;Return

End Start
