@echo off
  rem Assumes ..\src and ..\lib dirs
  echo.
  echo Create BCDASM library file (.LIB).
  for %%a in (16tc 16sc 16cc 16lc 16hc 16bc 16sp 16cp 16lp 16ts 16ss 16cs 16ls 32fs) do if %%a==%1 goto asm
  if (%1)==(****) goto liball

:USAGE
  echo Requires TASM and TLIB in path.
  echo.
  echo Usage: %0 memmodel [debug]
  echo where memmodel is one of:
  echo.
  echo  16tc   tiny, C          16ts   tiny, stdcall
  echo  16sc   small, C         16ss   small, stdcall
  echo  16cc   compact, C       16cs   compact, stdcall
  echo  16lc   large, C         16ls   large, stdcall
  echo  16hc   huge, C          32fs   flat, stdcall  (for Win32)
  echo  16bc   tchuge, C        ****   all models, in turn
  echo  16sp   small, pascal
  echo  16cp   compact, pascal
  echo  16lp   large, pascal
  echo.
  echo Optional: include line number debug info in .OBJ files
  echo           (requires TASM32 for memmodel 32fs)
  goto eof

:LIBALL
  echo -- All models selected
  for %%b in (16tc 16sc 16cc 16lc 16hc 16bc 16sp 16cp 16lp 16ts 16ss 16cs 16ls 32fs) do call %0 %%b %2
  goto eof

:ASM
  set oldFL=%FL%
  echo Assembling...(%1)
  if exist src\nul cd src
  cd ..\src
  if not exist ..\obj\nul md ..\obj > nul
  set FL=/t/i..\include /ml
  rem Need TASM32 to produce 32-bit debug info
  rem   (TASM v4.x has PUBDEF problems with /zi
  rem    and TASM32 v4.0 and v5.0 crash on /zi
  rem    so what's left is /zd       grrrrr...
  rem    Try: tdump -o bcdadd.obj)
  if (%2)==(debug) set FL=%FL%/zd
  if (%1)==(32fs) set FL=32%FL%
  tasm%FL% /dMDL=%1 @bcd.rsp, ..\obj\;
  if errorlevel 1 pause
  REM
  cd ..\lib
  if exist bcd%1.bak del bcd%1.bak
  if exist bcd%1.lib ren bcd%1.lib bcd%1.bak
  cd ..\obj
  tlib ..\lib\bcd%1.lib /C/0 +@..\src\bcd.rsp
  cd ..\lib
  set FL=%oldFL%
:EOF
