	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Compare two packed signed BCD numbers

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdCmp
;//	Desc	Compare two packed signed BCD numbers.
;//
;//
;//	Entry	Passed args
;//	Exit	Accumulator (and cf,zf,sf flags) set according to the
;//		(string) comparison: BCD1st - BCD2nd
;//		Acc = -1:  1st < 2nd
;//		Acc =  0:  1st = 2nd
;//		Acc = +1:  1st > 2nd
;//
;//	Note	Unlike bcdSub, this procedure returns the result based
;//		on a string comparison of the operands.

bcdCmp	proc
arg	BCD1st	:dataptr, \	; Addr of 1st BCD
	BCD2nd	:dataptr, \	; Addr of 2nd BCD
	BCDsz	:@uint		; Byte size of each BCD
@uses	ds,es,rsi,rdi,rcx
;.
	mov   rcx, [BCDsz]
	@LDS  rsi, [BCD1st]
	@LES  rdi, [BCD2nd]
	dec   rcx		; All but sign byte
	add   rsi, rcx		; Point to
	add   rdi, rcx		;   sign bytes
	mov   al, [rsi]		; Get top byte of 1st BCD
	mov   ah, @ES [rdi]	;   and of 2nd BCD
	and   rax, 8080h	; Isolate sign bits
	jz sh @@same_sign	; Result zero if both positive
	cmp   ah, al		; Are signs identical?
	jnz sh @@ret_sign	; No, skip string compare
	xchg  rsi, rdi		; Yes, swap pointers
@@same_sign:			;   since both are negative
	dec   rsi		; Point to byte before sign
	dec   rdi		;   in 2nd number, too
	std			; Auto-decrement index reg.s
	repe  cmpsb		; Compare high-to-low
	cld			; Clear direction flag
	mov   al, 0		; Assume [rsi] = [rdi]
	jz sh @@ret		; If so, exit
@@ret_sign:
	mov   al,-1		; Assume [rsi] < [rdi]
	jc sh @@ret		; Guessed right
	mov   al, 1		; Else must be [rsi] > [rdi]
@@ret:	ife @isUse32		; Sign-extend in accumulator
	cbw
	else
	movsx rax, al
	endif
	RET			; Return acc and cf,zf,sf
bcdCmp	endp

	END