	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Move (copy) a packed BCD

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdMov
;//	Desc	Move (copy) a packed BCD value.
;//
;//
;//	Entry	Passed args
;//	Exit	Destination = source. Acc undefined.

bcdMov	proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD (size=srcsz)
	srcBCD	:dataptr, \	; Addr of source BCD
	srcsz	:@uint		; Byte size of source BCD
@uses	ds,es,rsi,rdi,rcx
;.
	@cld
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	mov   rcx, [srcsz]
	rep   movsb
	RET
bcdMov	endp

	END