'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   PBClone  (C) Copyright 1996 Charon Software, All Rights Reserved   |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE FUNCTION IsLower% (Ch$)
   DECLARE SUB FClose1 (BYVAL FileHandle%)
   DECLARE SUB FOpen1 (FileName$, BYVAL ReadWrite%, BYVAL Sharing%, FileHandle%, ErrCode%)
   DECLARE SUB FSetOfs (BYVAL FileHandle%, Offset&)
   DECLARE SUB SFRead (BYVAL FileHandle%, St$, BytesRead%, ErrCode%)

   DECLARE FUNCTION AnyLowerCase% (St$)

SUB ObjScan (ObjFile$, ModName$, Routine$(), External$(), ErrCode%)
   St$ = ObjFile$
   IF INSTR(St$, ".") = 0 THEN St$ = St$ + ".OBJ"
   FOpen1 St$, 0, 2, Handle%, ErrCode%
   IF ErrCode% = 0 THEN
      RoutinePtr% = LBOUND(Routine$)
      ExternPtr% = LBOUND(External$)
      GOSUB ScanObject
      FClose1 Handle%
   END IF

   EXIT SUB

ScanObject:
   Done% = 0
   DO
      St$ = SPACE$(3)
      SFRead Handle%, St$, br%, ErrCode%
      IF ErrCode% THEN EXIT DO
      ObjTyp% = ASC(LEFT$(St$, 1))                         ' type of record
      ObjLen& = CVL(MID$(St$, 2) + STRING$(2, 0))          ' length of record
      IF ObjTyp% = &H80 THEN                   ' module name -----------------
         St$ = SPACE$(ObjLen&)
         SFRead Handle%, St$, br%, ErrCode%                ' get entire record
         IF ErrCode% THEN EXIT DO
         ModName$ = MID$(St$, 2, ASC(LEFT$(St$, 1)))       ' get module name
         tmp% = INSTR(ModName$, ":")                       ' remove misc junk
         IF tmp% THEN ModName$ = MID$(ModName$, tmp% + 1)
         DO
            tmp% = INSTR(ModName$, "\")
            IF tmp% THEN ModName$ = MID$(ModName$, tmp% + 1)
         LOOP WHILE tmp%
         DO
            tmp% = INSTR(ModName$, "/")
            IF tmp% THEN ModName$ = MID$(ModName$, tmp% + 1)
         LOOP WHILE tmp%
         tmp% = INSTR(ModName$, ".")
         IF tmp% THEN ModName$ = LEFT$(ModName$, tmp% - 1)
      ELSEIF ObjTyp% = &H8C THEN               ' external definitions --------
         St$ = SPACE$(ObjLen&)
         SFRead Handle%, St$, br%, ErrCode%                ' get entire record
         IF ErrCode% THEN EXIT DO
         St$ = LEFT$(St$, LEN(St$) - 1)                    ' remove checksum
         DO
            IF ExternPtr% > UBOUND(External$) THEN         ' if array overflow
               ErrCode% = -2
               EXIT DO
            END IF
            tmp% = ASC(LEFT$(St$, 1))                      ' routine name length
            Pub$ = MID$(St$, 2, tmp%)                      ' routine name
            St$ = MID$(St$, 2 + tmp% + 1)
                                                           ' skip BASIC internal names
            IF INSTR(Pub$, "$") = 0 AND LEFT$(Pub$, 1) <> "_" AND NOT AnyLowerCase(Pub$) AND RIGHT$(Pub$, 2) <> "QQ" THEN
               IF Pub$ <> "STRINGADDRESS" AND Pub$ <> "STRINGASSIGN" AND Pub$ <> "STRINGLENGTH" AND Pub$ <> "STRINGRELEASE" AND Pub$ <> "SETUEVENT" THEN
                  IF Pub$ <> "GETCONTAINER" AND Pub$ <> "GETPROPERTY" AND Pub$ <> "INVOKEEVENT" AND Pub$ <> "INVOKEMETHOD" AND Pub$ <> "SETPROPERTY" THEN
                     External$(ExternPtr%) = Pub$          ' store routine name
                     ExternPtr% = ExternPtr% + 1           ' update name ptr
                  END IF
               END IF
            END IF
         LOOP WHILE LEN(St$)
      ELSEIF ObjTyp% = &H90 THEN               ' public definitions ----------
         St$ = SPACE$(ObjLen&)
         SFRead Handle%, St$, br%, ErrCode%                ' get entire record
         IF ErrCode THEN EXIT DO
         St$ = LEFT$(St$, LEN(St$) - 1)                    ' remove checksum
         IF LEFT$(St$, 2) = STRING$(2, 0) THEN             ' remove header
            St$ = MID$(St$, 5)
         ELSE
            St$ = MID$(St$, 3)
         END IF
         DO
            IF RoutinePtr% > UBOUND(Routine$) THEN         ' if array overflow
               ErrCode% = -2
               EXIT DO
            END IF
            tmp% = ASC(LEFT$(St$, 1))                      ' routine name len
            Routine$(RoutinePtr%) = MID$(St$, 2, tmp%)     ' get a routine name
            RoutinePtr% = RoutinePtr% + 1                  ' update name ptr
            St$ = MID$(St$, 2 + tmp% + 3)                  ' wipe from rec info
         LOOP WHILE LEN(St$)
      ELSEIF ObjTyp% = &H8A THEN               ' end of module ---------------
         Done% = -1
      ELSE                                     ' skip anything else ----------
         FSetOfs Handle%, ObjLen&
      END IF
   LOOP UNTIL ErrCode% OR Done%
   IF ErrCode% = 0 THEN
      IF ExternPtr% <= UBOUND(External$) THEN
         External$(ExternPtr%) = ""
      END IF
      IF RoutinePtr% <= UBOUND(Routine$) THEN
         Routine$(RoutinePtr%) = ""
      END IF
   END IF
   RETURN
END SUB



FUNCTION AnyLowerCase% (St$)
   FOR x% = 1 TO LEN(St$)
      IF IsLower%(MID$(St$, x%, 1)) THEN
         lc% = -1
         EXIT FOR
      END IF
   NEXT
   AnyLowerCase% = lc%
END FUNCTION
