'
'  -- MODEM_IO.BAS --
'
' This program is donated to the Public
' Domain by MarshallSoft Computing, Inc.
' It is provided as an example of the use
' of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL ON      'turn on all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFINT A-Z

$INCLUDE "MODEM_IO.BI"
$INCLUDE "PCL4PB.BI"

%False = 0
%True  = NOT %False

DIM DebugFlag AS SHARED INTEGER          ' DEBUG flag

DIM MatchArray(255) AS SHARED BYTE       ' ModemWaitFor() match string
DIM MatchLength AS SHARED INTEGER        ' string length
DIM MatchCount AS SHARED INTEGER         ' # sub-strings
DIM MatchStart(10) AS SHARED INTEGER     ' 1st char of sub-string
DIM MatchIndex(10) AS SHARED INTEGER     ' index to next char


FUNCTION MatchChar(BYVAL C AS BYTE) PRIVATE AS INTEGER
 DIM I AS INTEGER
 DIM Index AS INTEGER
 DIM Start AS INTEGER
 ' consider each string in turn
 FOR I = 0 TO MatchCount - 1
    Index = MatchIndex(I)
    Start = MatchStart(I)
    IF MatchArray(Index) = C THEN
       ' char C matches
       Index = Index + 1
       IF (MatchArray(Index) = ASC("|")) OR (Index >= MatchLength) THEN
          MatchIndex(I) = Start
          MatchChar = I
          EXIT FUNCTION
       ELSE
          MatchIndex(I) = Index
       END IF
    ELSE
       ' char C does NOT match
       MatchIndex(I) = Start
       ' look again if was not 1st char
       IF Index <> Start THEN
          I = I - 1
       END IF
    END IF
 NEXT I
 MatchChar = -1
END FUNCTION

FUNCTION BreakTest() PUBLIC AS INTEGER

  ' User BREAK ?
  IF (INKEY$ <> "" ) OR SioBrkKey THEN
    PRINT "User BREAK"
    BreakTest = %True
    EXIT FUNCTION
  END IF

  BreakTest = %False

END FUNCTION

' Initialize

SUB MatchInit(S AS STRING) PUBLIC
 DIM I AS INTEGER
 DIM C AS BYTE
 DIM Index AS INTEGER
 MatchLength = LEN(S)
 FOR I = 1 TO MatchLength
   MatchArray(I-1) = ASC(MID$(S,I,1))
 NEXT I
 ' mark 1st sub-string
 MatchStart(0) = 0
 MatchIndex(0) = 0
 MatchCount = 1
 Index = 1
 ' find start of each sub-string
 WHILE Index < MatchLength
   IF MatchArray(Index) = ASC("|") THEN
       ' mark start of next string
       MatchStart(MatchCount) = Index + 1
       MatchIndex(MatchCount) = Index + 1
       MatchCount = MatchCount + 1
   END IF
   Index = Index + 1
 WEND
END SUB

' enter command state
' NOTE: assumes escape char = '+' & guard time = 1 sec

FUNCTION ModemCmdState(BYVAL Port AS INTEGER) PUBLIC AS INTEGER

  DIM Code AS INTEGER
  DIM I    AS INTEGER

  ' delay a bit over 1 second
  Code = SioDelay(25)

  ' send Escape Code exactly 3 times
  FOR I = 1 TO 3
    Code = SioPutc(Port, ASC("+"))
    Code = SioDelay(5)
  NEXT I

  ' delay again
  Code = SioDelay(25)

END FUNCTION


' echos incoming to screen

FUNCTION ModemEcho(BYVAL Port AS INTEGER, _
                   BYVAL Echo AS INTEGER) PUBLIC AS INTEGER
  DIM Time AS LONG
  DIM Code AS INTEGER

  Time = SioTimer
  DO WHILE SioTimer < Time + Echo
    Code = SioGetc(Port, 1)
    IF Code = 13 THEN
      PRINT
    ELSEIF Code >= &H20 THEN
      PRINT CHR$(Code);
    END IF
  LOOP

END FUNCTION


' wait for continuous quiet (no incoming serial data)

FUNCTION ModemQuiet(BYVAL Port AS INTEGER, _
                    BYVAL Tics AS INTEGER) PUBLIC AS INTEGER
  DIM CharTime AS LONG
  DIM Code     AS INTEGER

  ' set up
  CharTime = SioTimer

  DO
    ' User BREAK ?
    IF BreakTest THEN
      ModemQuiet = %False
      EXIT FUNCTION
    END IF

    ' wait for next character
    Code = SioGetc(Port, 1)
    IF Code < -1 THEN
      ModemQuiet = %False
      EXIT FUNCTION
    END IF
    IF Code >= 0 THEN
      CharTime = SioTimer
      IF Code = 10 THEN
        PRINT
      ELSEIF Code >= &H20 THEN
        PRINT CHR$(Code);
      END IF
    ELSE
      ' =-1, timed out
      IF SioTimer >= CharTime + Tics THEN
         ModemQuiet = %True
         EXIT FUNCTION
      END IF
    END IF
  LOOP

END FUNCTION

' send string to modem & get echo

FUNCTION ModemSendTo(BYVAL Port AS INTEGER, _
                     BYVAL Pace AS INTEGER, _
                     Text AS STRING) PUBLIC AS INTEGER
  DIM I       AS INTEGER
  DIM Code    AS INTEGER
  DIM TheByte AS INTEGER
  DIM TheChar AS STRING

  I = 1
  WHILE I <= LEN(Text$)
    ' User BREAK ?
    IF BreakTest THEN
      ModemSendTo = %False
      EXIT FUNCTION
    END IF
    ' delay <Pace> tics
    IF Pace > 0 THEN Code = ModemEcho(Port, Pace)
    ' fetch character
    TheChar$ = MID$(Text$, I, 1)
    I = I + 1
    TheByte = ASC(TheChar$)

    SELECT CASE TheChar$
      CASE "!"
        ' replace ! with carriage return
        TheByte = 13
      CASE "~"
        ' delay 1/2 second
        Code = SioDelay(10)
        TheByte = &H20
      CASE " "
        ' delay 1/4 second
        Code = SioDelay(5)
        TheByte = &H20
      CASE "^"
        TheChar$ = MID$(Text$, I, 1)
        I = I + 1
        TheByte = ASC(TheChar$) - ASC("A") + 1
    END SELECT

    ' transmit
    Code = SioPutc(Port, TheByte)
  WEND

  ModemSendTo = %True

END FUNCTION

' wait for Text$
'
' NOTES:
'  (1)  Will return 0 if no match, else ASC("0") if 1st, ASC("1") if 2nd, etc.
'       where String = "<1st substr>|<2nd substr>| ..."
'  (2)  Example call: ModemWaitFor(COM1,180,%False,"more ?|Menu:")'

FUNCTION ModemWaitFor(BYVAL Port     AS INTEGER, _
                      BYVAL Tics     AS INTEGER, _
                      BYVAL CaseFlag AS INTEGER, _
                            Text     AS STRING) PUBLIC AS INTEGER
  DIM Time   AS LONG
  DIM C      AS BYTE
  DIM Code   AS INTEGER
  DIM First  AS INTEGER
  DIM Length AS INTEGER
  DIM I      AS INTEGER

  Length = LEN(Text$)

  IF NOT CaseFlag THEN
    Text$ = UCASE$(Text$)
  END IF
  MatchInit(Text$)
  IF DebugFlag THEN
    PRINT " [Awaiting ";Text$;"]"
  END IF
  ' wait for string
  Time = SioTimer
  First = 1
  DO WHILE SioTimer < Time + Tics
    ' User BREAK ?
    IF BreakTest THEN
      ModemWaitFor = %False
      EXIT FUNCTION
    END IF
    ' wait for next character
    Code = SioGetc(Port, 1)
    IF Code < -1 THEN
      ModemWaitFor = %False
      EXIT FUNCTION
    END IF
    IF Code >= 0 THEN
      ' echo char
      IF Code = 10 THEN
        PRINT
      ELSEIF Code >= &H20 THEN
        PRINT CHR$(Code);
      END IF

      IF CaseFlag THEN
         C = Code
      ELSE
         C = ASC(UCASE$(CHR$(Code)))
      END IF

      ' does char match ?
      Code = MatchChar(C)
      IF Code >= 0 THEN
        ModemWaitFor =  ASC("0") + Code
        EXIT FUNCTION
      ELSE
        'start over again
        First = 1
      END IF
    END IF
  LOOP

  ModemWaitFor = 0

END FUNCTION



' hangup phone (in command state)

FUNCTION ModemHangup(BYVAL Port AS INTEGER) PUBLIC AS INTEGER

  DIM Code AS INTEGER

  ' enter command state
  Code = ModemCmdState(Port)

  ' hangup !
  Code = ModemSendTo(Port, 4, "!AT!")
  Code = ModemEcho(Port, 10)
  Code = ModemSendTo(Port, 4, "ATH0!")

END FUNCTION

SUB ModemDebug(BYVAL Debug AS INTEGER) PUBLIC
  DebugFlag = Debug
END SUB
