'
'  SIMPLE.BAS Example Program
'

$ERROR ALL ON
$LIB ALL OFF
$LINK "PCL4PB.OBJ"
$INCLUDE "PCL4PB.BI"

'declare variables
DIM Buffer(256+16) AS BYTE
DIM BufSeg AS WORD
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM LibVer AS INTEGER
DIM BaudCode AS INTEGER
DIM AnyKey AS STRING
DIM RATES(12) AS STRING
DIM PARMS AS STRING
DIM ARG1 AS STRING
DIM ARG2 AS STRING

RATES$(1) = "300"
RATES$(2) = "600"
RATES$(3) = "1200"
RATES$(4) = "2400"
RATES$(5) = "4800"
RATES$(6) = "9600"
RATES$(7) = "19200"
RATES$(8) = "38400"
RATES$(9) = "57600"
RATES$(10) = "115200"

PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: SIMPLE <Port> <BaudRate>"
  PRINT "Example: SIMPLE 1 9600"
  END
END IF
L = LEN(PARMS$)
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
BaudCode = -1

'Get COM port
Port = VAL(ARG1$) - 1

'Get baud code
FOR I = 1 TO 10
  IF RATES$(I) = ARG2$ THEN
     BaudCode = I - 1
     EXIT FOR
  END IF
NEXT I

'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; ARG2$
  STOP
END IF

'Reset port
BufSeg = 1 + VARSEG(Buffer(0)) + (VARPTR(Buffer(0)) \ 16)
Code = SioRxBuf(Port, BufSeg, %Size256)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

Code = SioReset(Port, %Baud2400)

IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF

CLS

PRINT "SIMPLE 9/25/94"
PRINT " "
LibVer = SioInfo(ASC("V"))
PRINT "Library Version: "; LibVer \ 16; ".";
PRINT LibVer MOD 16

PRINT "Entering TERMINAL loop (^Z to quit)..."

Code = SioDTR(Port, %SET.LINE)
Code = SioRTS(Port, %SET.LINE)

DO
  'Anything incoming ?
  Code = SioGetc(Port, 1)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)

END
                  