echo off
echo.
echo Ŀ
echo  Directory with sort and generalized name matching 
echo  By Prof. Timo Salmi, ts@uwasa.fi, Sat 5-Oct-96    
echo 
echo.

if "%ram%"=="" goto _noram

rem If no parameters are given to the batch, then display help
if "%1"=="" goto _help

rem Check that a (ram)disk exists on %ram%:
if not exist %ram%:\nul goto _err1

rem Eliminate wildcards (they are implicit)
for %%f in (%1) do if "%%f"=="%1" goto _makeup
echo Wildcards are implicit and should not be used
goto _out

rem Make the searchstring uppercase
:_makeup
set _tmp=%path%
path %1
set _upcase=%path%
path %_tmp%

rem Make a temporary directory
dir *.* > %ram%:\d.tmp

rem Read the switches
set _n=
set _e=
set _s=
set _r=
:_loop
shift
if "%1"=="" goto _sort_1
if "%1"=="/n" set _n=yes
if "%1"=="/N" set _n=yes
if "%1"=="/e" set _e=yes
if "%1"=="/E" set _e=yes
if "%1"=="/s" set _s=yes
if "%1"=="/S" set _s=yes
if "%1"=="/r" set _r=/r
if "%1"=="/R" set _r=/r
goto _loop

rem The sorting routines
:_sort_1
if "%_n%"=="yes" goto _sort_n
:_sort_2
if "%_e%"=="yes" goto _sort_e
:_sort_3
if "%_s%"=="yes" goto _sort_s
:_sort_4
goto _display

:_sort_n
sort %_r% < %ram%:\d.tmp > %ram%:\tmp$$$.$$$
copy %ram%:\tmp$$$.$$$ %ram%:\d.tmp > nul
del %ram%:\tmp$$$.$$$
goto _sort_2

:_sort_e
sort %_r% /+10 < %ram%:\d.tmp > %ram%:\tmp$$$.$$$
copy %ram%:\tmp$$$.$$$ %ram%:\d.tmp > nul
del %ram%:\tmp$$$.$$$
goto _sort_3

:_sort_s
sort %_r% /+14 < %ram%:\d.tmp > %ram%:\tmp$$$.$$$
copy %ram%:\tmp$$$.$$$ %ram%:\d.tmp > nul
del %ram%:\tmp$$$.$$$
goto _sort_4

rem Find the entries containing the searchstring
:_display
find "%_upcase%" %ram%:\d.tmp | more
goto _out

:_help
echo D is a DIR command enhancement. It uses a generalized searchstring which is
echo matched with the file name REGARDLESS of the location of the string within
echo the file name. Wildcards (* and ?) should not be used. They are implicit.
echo.
echo Usage: D SearchString [/n] [/e] [/s] [/r]
echo                                      Reverse the sort
echo                                  Sort by size
echo                              Sort by extension
echo                          Sort by name
echo.
echo Examples: D bat /s /r  (all batch files sorted from biggest to smallest)
echo           D - /n       (see the entire sorted directory (- or . or :) )
echo           D j          (all file names having a J in them, unsorted)
echo           D /r         (error in logic, no sort key has been defined)
echo.
echo If you get an "Out of environment space" message, increase your environment
echo space by using shell configuration in config.sys apply the following MsDos
echo 3.30 example: shell=c:\bin\command.com /e:1024 /p
goto _out

:_err1
echo D.BAT assumes by default a (ram)disk in drive %rem%.

:_out
if exist %ram%:\d.tmp del %ram%:\d.tmp
set _tmp=
set _upcase=
set _n=
set _e=
set _s=
set _r=
goto _out2

:_noram
echo Environment variable RAM not set, exiting
echo Set it in your autoexec.bat to point to the ramdisk letter
:_out2
