	.386

SIGSEGV = 11
SIGBREAK = 21
SIGFPE = 8
SIGILL = 4

_SIG		segment para public use16 'TRAN'
_SIG		ends
_TEXT		segment para public use32 'CODE'
		extrn __rexit:proc, _raise:proc, dos:proc, __transferx:word
		extrn nametodta:proc, __stacktop : dword, __pmodew:word

_TEXT		ends
_DATA   	SEGMENT DWORD PUBLIC USE32 'DATA'
                ENDS

	public	llsignal, breakflag, llsigdown, raisecb, pmodeds, setxcept, fullraise

DGROUP group _TEXT, _DATA

_DATA		segment
breakflag	dd	?
pmodeds		dw	?
cbofs		dw	?
cbseg		dw	?
oldctbrk	dd	?
div0msg		db	10,13,"Divide by zero or into",10,13,'$',0
msg13		db	10,13,"Protection violation",10,13,'$',0
_DATA		ends

_TEXT		segment
		assume cs:DGROUP,ds:DGROUP
;__________________________________________________________________________

setxcept:
		mov ecx,cs
		pushad
		mov ax,203h
		int 31h
		popad
		jnc sxcok
setxcept2:
		mov ecx,cs
		mov ax,205h
		int 31h
sxcok:		
		ret
llsignal:
		mov	[pmodeds],ds	; set for callbacks

		mov bl,13
		mov edx,offset DGROUP:raise13
		call setxcept

		mov bl,14
		mov edx,offset DGROUP:raise13
		call setxcept

		mov bl,6
		mov edx,offset DGROUP:raise13
		call setxcept

		mov bl,1
		mov edx,offset DGROUP:int1ret
		call setxcept2

		mov bl,3
		mov edx,offset DGROUP:int3ret
		call setxcept2

		mov bl,0
		mov edx,offset DGROUP:div0
		call setxcept

		mov bl,4
		mov edx,offset DGROUP:div0
		call setxcept

		mov bl,23h		; save the old int 23 handler
		mov ax,200h
		mov word ptr [oldctbrk],dx
		mov word ptr [oldctbrk+2],cx
					; allocate a real mode call back
		mov ax,303h		; for ctrl-break
		mov esi,offset DGROUP:sigcb
		push es
		mov es,[__transferx]
		add edi,1024-32
		push ds
		push cs
		pop ds
		int 31h
		pop ds
		pop es
		mov [cbseg],cx
		mov [cbofs],dx
		jc  @@exit

		mov bl,23h		; set the callback as ctrl-brk
		mov ax,201h
		int 31h
@@exit:
		ret
;__________________________________________________________________________

llsigdown:
		mov bl,23h		; set the old ctbrk handler
		mov ax,201h
		mov cx,word ptr [oldctbrk]
		mov dx,word ptr [oldctbrk+2]
		int 31h

		mov ax,304h		; free callback
		mov cx,[cbseg]
		mov dx,[cbofs]
		int 31h

		ret
;__________________________________________________________________________
					; vector and then we would....
raise13:
		sti
		mov	ds,cs:[pmodeds]
		mov	es,cs:[pmodeds]
		mov 	esi,offset DGROUP:msg13
		mov 	ax,ds
		mov 	bx,ss
		cmp	ax,bx
		jnz	fullraise

		push	SIGSEGV
		call	_raise
		pop	ecx       	; we shouldn't get here...
		jmp	__rexit		; well I guess they COULD ignore the
					; vector and then we would....
;
; this next is called from the DOS call routine
; if there was a ctrl-break while we were calling DOS
; this is because can't exit DPMI from a callback...
;
raisecb:
		mov	[breakflag],0	; acknowledge in callback
		push	SIGBREAK
		call	_raise
		pop	ecx       	; we shouldn't get here...
		jmp	__rexit		; well I guess they COULD ignore the
					; vector and then we would....
div0:
		sti
		mov	ds,cs:[pmodeds]
		mov	es,cs:[pmodeds]
		mov 	esi,offset DGROUP:div0msg
fullraise:
		mov 	edx,esi
		mov	ax,ds
		mov 	bx,ss
		test	[__pmodew],0ffffh
		jnz	nodta
		call	nametodta
		mov 	ah,9
		call	dos
		jmp	join
nodta:
		mov	ah,9
		int 	21h
join:
		cli
		mov	ax,ds
		mov	ss,ax
		mov 	esp,[__stacktop]
		sti

		jmp	__rexit

int3ret:
		inc	dword ptr [esp]		; bump past the int 3
int1ret:                                ; if they have tracing on ignore it
		iretd			
;__________________________________________________________________________
sigcb:
;
; set our break flag
;
		push	ds
		mov	ds,cs:[pmodeds]
		mov	[breakflag],1	; can't return from a callback
					; but we must have called DOS 
					; to get a break signal...
		pop     ds
;
; now do housekeeping required of real-mode callbacks
;
		mov	ax,[esi]	; Select the return address for the cb
		mov 	es:[edi+2ah],ax
		mov	ax,[esi+2]
		mov 	es:[edi+2ch],ax
		add	word ptr es:[edi+2eh],6 ; get rid of the interrupt stack frame
		iretd
		

_TEXT		ends
		end