/* --------------------- video.c -------------------- */

#include "dflat.h"

BOOL ClipString;
static BOOL snowy;

static unsigned short video_address;
static short near vpeek(short *vp);
static void near vpoke(short *vp, short c);
void movefromscreen(void *bf, short offset, short len);
void movetoscreen(void *bf, short offset, short len);

/* -- read a rectangle of video memory into a save buffer -- */
void getvideo(RECT rc, void *bf)
{
    short ht = RectBottom(rc)-RectTop(rc)+1;
    short bytes_row = (RectRight(rc)-RectLeft(rc)+1) * 2;
    unsigned short vadr = vad(RectLeft(rc), RectTop(rc));
    hide_mousecursor();
    while (ht--)    {
		movefromscreen(bf, vadr, bytes_row);
        vadr += SCREENWIDTH*2;
        bf = (char *)bf + bytes_row;
    }
    show_mousecursor();
}

/* -- write a rectangle of video memory from a save buffer -- */
void storevideo(RECT rc, void *bf)
{
    short ht = RectBottom(rc)-RectTop(rc)+1;
    short bytes_row = (RectRight(rc)-RectLeft(rc)+1) * 2;
    unsigned short vadr = vad(RectLeft(rc), RectTop(rc));
    hide_mousecursor();
    while (ht--)    {
		movetoscreen(bf, vadr, bytes_row);
        vadr += SCREENWIDTH*2;
        bf = (char *)bf + bytes_row;
    }
    show_mousecursor();
}

/* -------- read a character of video memory ------- */
unsigned short GetVideoChar(short x, short y)
{
    short c;
    hide_mousecursor();
	if (snowy)
	    c = vpeek(MK_FP(video_address, vad(x,y)));
	else
	    c = peek(video_address, vad(x,y));
    show_mousecursor();
    return c;
}

/* -------- write a character of video memory ------- */
void PutVideoChar(short x, short y, short c)
{
    if (x < SCREENWIDTH && y < SCREENHEIGHT)    {
        hide_mousecursor();
		if (snowy)
	        vpoke(MK_FP(video_address, vad(x,y)), c);
		else
	        poke(video_address, vad(x,y), c);
        show_mousecursor();
    }
}

BOOL CharInView(WINDOW wnd, short x, short y)
{
	WINDOW nwnd = NextWindow(wnd);
	WINDOW pwnd;
	RECT rc;
    short x1 = GetLeft(wnd)+x;
    short y1 = GetTop(wnd)+y;

	if (!TestAttribute(wnd, VISIBLE))
		return FALSE;
    if (!TestAttribute(wnd, NOCLIP))    {
        WINDOW wnd1 = GetParent(wnd);
        while (wnd1 != NULL)    {
            /* --- clip character to parent's borders -- */
			if (!TestAttribute(wnd1, VISIBLE))
				return FALSE;
			if (!InsideRect(x1, y1, ClientRect(wnd1)))
                return FALSE;
            wnd1 = GetParent(wnd1);
        }
    }
	while (nwnd != NULL)	{
		if (!isHidden(nwnd) && !isAncestor(wnd, nwnd))	{
			rc = WindowRect(nwnd);
    		if (TestAttribute(nwnd, SHADOW))    {
        		RectBottom(rc)++;
        		RectRight(rc)++;
    		}
			if (!TestAttribute(nwnd, NOCLIP))	{
				pwnd = nwnd;
				while (GetParent(pwnd))	{
					pwnd = GetParent(pwnd);
					rc = subRectangle(rc, ClientRect(pwnd));
				}
			}
			if (InsideRect(x1,y1,rc))
				return FALSE;
		}
		nwnd = NextWindow(nwnd);
	}
    return (x1 < SCREENWIDTH && y1 < SCREENHEIGHT);
}

/* -------- write a character to a window ------- */
void wputch(WINDOW wnd, short c, short x, short y)
{
	if (CharInView(wnd, x, y))	{
		short ch = (c & 255) | (clr(foreground, background) << 8);
		short xc = GetLeft(wnd)+x;
		short yc = GetTop(wnd)+y;
        hide_mousecursor();
		if (snowy)
        	vpoke(MK_FP(video_address, vad(xc, yc)), ch);
		else
        	poke(video_address, vad(xc, yc), ch);
        show_mousecursor();
	}
}

/* ------- write a string to a window ---------- */
void wputs(WINDOW wnd, void *s, short x, short y)
{
	short x1 = GetLeft(wnd)+x;
	short x2 = x1;
	short y1 = GetTop(wnd)+y;
    if (x1 < SCREENWIDTH && y1 < SCREENHEIGHT && isVisible(wnd))	{
		short ln[200];
		short *cp1 = ln;
	    unsigned char *str = s;
	    short fg = foreground;
    	short bg = background;
	    short len;
		short off = 0;
        while (*str)    {
            if (*str == CHANGECOLOR)    {
                str++;
                foreground = (*str++) & 0x7f;
                background = (*str++) & 0x7f;
                continue;
            }
            if (*str == RESETCOLOR)    {
                foreground = fg & 0x7f;
                background = bg & 0x7f;
                str++;
                continue;
            }
   	        *cp1 = (*str & 255) | (clr(foreground, background) << 8);
			if (ClipString)
				if (!CharInView(wnd, x, y))
					*cp1 = peek(video_address, vad(x2,y1));
			cp1++;
			str++;
			x++;
			x2++;
        }
        foreground = fg;
        background = bg;
   		len = (short)(cp1-ln);
   		if (x1+len > SCREENWIDTH)
       		len = SCREENWIDTH-x1;

		if (!ClipString && !TestAttribute(wnd, NOCLIP))	{
			/* -- clip the line to within ancestor windows -- */
			RECT rc = WindowRect(wnd);
			WINDOW nwnd = GetParent(wnd);
			while (len > 0 && nwnd != NULL)	{
				if (!isVisible(nwnd))	{
					len = 0;
					break;
				}
				rc = subRectangle(rc, ClientRect(nwnd));
				nwnd = GetParent(nwnd);
			}
			while (len > 0 && !InsideRect(x1+off,y1,rc))	{
				off++;
				--len;
			}
			if (len > 0)	{
				x2 = x1+len-1;
				while (len && !InsideRect(x2,y1,rc))	{
					--x2;
					--len;
				}
			}
		}
		if (len > 0)	{
        	hide_mousecursor();
			movetoscreen(ln+off, vad(x1+off,y1), len*2);
        	show_mousecursor();
		}
    }
}

/* --------- get the current video mode -------- */
void get_videomode(void)
{
    videomode();
    /* ---- Monochrome Display Adaptor or text mode ---- */
	snowy = FALSE;
    if (ismono())
        video_address = 0xb000;
    else	{
        /* ------ Text mode -------- */
        video_address = 0xb800 + video_page;
		if (!isEGA() && !isVGA())
			/* -------- CGA --------- */
			snowy = cfg.snowy;
	}
}

/* --------- scroll the window. d: 1 = up, 0 = dn ---------- */
void scroll_window(WINDOW wnd, RECT rc, short d)
{
	if (RectTop(rc) != RectBottom(rc))	{
		union REGS regs;
		regs.h.cl = RectLeft(rc);
		regs.h.ch = RectTop(rc);
		regs.h.dl = RectRight(rc);
		regs.h.dh = RectBottom(rc);
		regs.h.bh = clr(WndForeground(wnd),WndBackground(wnd));
		regs.h.ah = 7 - d;
		regs.h.al = 1;
    	hide_mousecursor();
#ifdef __FLAT__
    	int386(VIDEO, &regs, &regs);
#else
    	int86(VIDEO, &regs, &regs);
#endif
    	show_mousecursor();
	}
}


#ifndef WATCOM
static void near waitforretrace(void)
{
asm		mov		dx,3dah
loop1:
asm		mov		cx,6
loop2:
asm		in		al,dx
asm		test	al,8
asm		jnz		loop2
asm		test	al,1
asm		jz		loop2
asm		cli
loop3:
asm		in		al,dx
asm		test	al,1
asm		loopnz	loop3
asm		sti
asm		jz		loop1
}
#else
void waitforretrace(void);
#pragma aux waitforretrace = \
		"mov		dx,3dah",	\
"loop1:",						\
		"mov		cx,6",		\
"loop2:",						\
		"in		al,dx",		\
		"test		al,8",		\
		"jnz		loop2",		\
		"test		al,1",		\
		"jz		loop2",		\
		"cli",					\
"loop3:",						\
		"in		al,dx",		\
		"test		al,1",		\
		"loopnz	loop3",		\
		"sti",					\
		"jz		loop1";

#endif

void movetoscreen(void *bf, short offset, short len)
{
#ifdef __FLAT__
	if (snowy)
		waitforretrace();
	memcpy(MK_FP(video_address, offset), bf, len);
#else
	if (snowy)
		waitforretrace();
	movedata(FP_SEG(bf), FP_OFF(bf), video_address, offset, len);
#endif
}

void movefromscreen(void *bf, short offset, short len)
{
#ifdef __FLAT__
	if (snowy)
		waitforretrace();
	memcpy(bf, MK_FP(video_address, offset), len);
#else
	if (snowy)
		waitforretrace();
	movedata(video_address, offset,	FP_SEG(bf), FP_OFF(bf),	len);
#endif
}


static short near vpeek(short *vp)
{
	short c;
	waitforretrace();
	c = *vp;
	return c;
}

static void near vpoke(short *vp, short c)
{
	waitforretrace();
	*vp = c;
}


