/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

/* Demonstrates reading the mouse coordinates */

#define COLOR 100

int main(void)
{
 int xpos,ypos,buttons;
 int stx,sty,edx,edy;
 image *jlb_pic;
 buffer_rec *offscreen;


 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 if(!MOUSE_AVAILABLE){
    jlib_exit("No Mouse Support.");
 }

 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* load jlb */
 jlb_pic = image_load_jlb("demo4.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
    jlib_exit("JLB Load Failed.");
 }

 if(!mouse_present()){
    jlib_exit("No Mouse Installed.");
 }
 mouse_show_pointer();

 screen_block_set_pal(IMG_PALETTE(jlb_pic));
 screen_put_pal(255,0,0,0);   /* for the mouse outline */
 
 /* copy the image to the buffer */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));

 /* draw the 'exit' box to the buffer */
 buff_draw_rectNC(offscreen,0,0,(SCREEN_WIDTH/10),(SCREEN_HEIGHT/10),15);

 /* hide the mouse pointer temporarily */
 mouse_hide_pointer();
  
 /* show buffer and turn on mouse pointer */
 screen_blit_fs_buffer(offscreen);
 mouse_show_pointer();
  
 /* this loop draws lines from the position the mouse is at when the 
    buttons are pressed.                                             */
 do{
    mouse_get_status(&xpos,&ypos,&buttons);

    if((xpos<SCREEN_WIDTH/10)&&(ypos<SCREEN_HEIGHT/10)&&(BUTTON_DOWN(buttons))){
       break;
    }

    if(BUTTON_DOWN(buttons)){
       stx=xpos;
       sty=ypos;
       do{
	 mouse_get_status(&xpos,&ypos,&buttons);
	 if(!BUTTON_DOWN(buttons)){
	    edx=xpos;
	    edy=ypos;
	    mouse_hide_pointer();
	    buff_draw_line(offscreen,stx,sty,edx,edy,COLOR);
	    screen_blit_fs_buffer(offscreen);
	    mouse_show_pointer();
	    break;
	 }
       }while(1);
    }
 }while(1);

 /* wait until click is released before going on */
 do{
    mouse_get_status(&xpos,&ypos,&buttons);
 }while(BUTTON_DOWN(buttons));

 mouse_hide_pointer();
 
 /* copy the buffer over again */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));

 /* draw the 'exit' box to the buffer */
 buff_draw_rect(offscreen,0,0,(SCREEN_WIDTH/10),(SCREEN_HEIGHT/10),15);

 screen_blit_fs_buffer(offscreen);


 /* this loop draws boxes from the position the mouse is at when the left  **
 ** buttons are pressed.                                                   */
 mouse_show_pointer();

 do{
    mouse_get_status(&xpos,&ypos,&buttons);

    if((xpos<SCREEN_WIDTH/10)&&(ypos<SCREEN_HEIGHT/10)&&(BUTTON_DOWN(buttons))){
       break;
    }

    if(BUTTON_DOWN(buttons)){
       stx=xpos;
       sty=ypos;
       do{
	 mouse_get_status(&xpos,&ypos,&buttons);
	 if(!BUTTON_DOWN(buttons)){
	    edx=xpos;
	    edy=ypos;

	    mouse_hide_pointer();
	    buff_draw_box(offscreen,stx,sty,edx,edy,100);
	    screen_blit_fs_buffer(offscreen);
	    mouse_show_pointer();
	    break;
	 }
       }while(1);
    }
 }while(1);

 /* set text mode and exit */
 screen_restore_video_mode();
 
 return(1);
}
