/* Copyright 1995-96 Arturo Espinosa and Jon Griffiths.See the file "jlib.doc"
 *  for copyright details. Based on Joystick code by Arturo Espinosa.
 */
#if (JOYSTICK_AVAILABLE == 1) 	
#include <jlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <linux/joystick.h>

int __jlib_num_joysticks = 0;
logical_joy __jlib_joys[3];


/*+------------------------------------------------------------------------+*/
/*| Return the number of joysticks connected.                              |*/
/*+------------------------------------------------------------------------+*/
int joystick_count(void)
{
  int j1=0,j2=0;

  __jlib_joys[1].joy=-1;
  __jlib_joys[2].joy=-1;

  if ((j1 = open ("/dev/js0",  O_RDONLY)) >= 0)
        __jlib_num_joysticks++;

  if ((j2 = open ("/dev/js1",  O_RDONLY)) >= 0)
        __jlib_num_joysticks++;

  switch (__jlib_num_joysticks) {
    case 2:
            __jlib_joys[2].joy=j2;
    case 1: 
            if (j1 >= 0) {
              __jlib_joys[1].joy=j1;
            }
            else {
              __jlib_joys[1].joy=j2;
            }
  }

  return __jlib_num_joysticks;
}


/*+------------------------------------------------------------------------+*/
/*| Initialise a given joystick.                                           |*/
/*+------------------------------------------------------------------------+*/
int joystick_init(int which)
{
  if((which < 1) || (which > 2) || (which > __jlib_num_joysticks)){
    return 0;
  }
  if (__jlib_joys[which].joy >= 0) {
      return 1;
  }
}


/*+------------------------------------------------------------------------+*/
/*| Uninitialise a given joystick.                                         |*/
/*+------------------------------------------------------------------------+*/
void joystick_closedown(int which)
{
#ifndef JLIB_PRODUCTION
  if((which < 1) || (which > 2) || (which > __jlib_num_joysticks)){
    jlib_exit("Invalid joystick");
  }
#endif

  if (__jlib_joys[which].joy >= 0) {
      close (__jlib_joys[which].joy);
      __jlib_joys[which].joy = -1;
  }
}


/*+------------------------------------------------------------------------+*/
/*| Return raw values from a joystick.                                     |*/
/*+------------------------------------------------------------------------+*/
void joystick_get_status(int which,int *x_axis,int *y_axis,int *b_status)
{
  struct JS_DATA_TYPE js;

#ifndef JLIB_PRODUCTION
  if((which < 1) || (which > 2) || (which > __jlib_num_joysticks)){
    jlib_exit("Invalid joystick");
  }
#endif
  *bstatus = *x_axis = *y_axis = 0;

  if (__jlib_joys[which].joy < 0) {
      return;
  }
	
  if (read (__jlib_joys[which].joy, &js, JS_RETURN) < 0){
      return;
  }

  *x_axis   = js.x;
  *y_axis   = jx.y;
  *b_status = js.buttons;               
}


/*+------------------------------------------------------------------------+*/
/*| Set up joystick calibration for joystick_get_direction()               |*/
/*+------------------------------------------------------------------------+*/
void joystick_calibrate(int which,int l,int r,int t,int b,int x_cen,int y_cen)
{
#ifndef JLIB_PRODUCTION
  if((which < 1) || (which > 2) || (which > __jlib_num_joysticks) || (__jlib_joys[which].joy <0)) {
    jlib_exit("Invalid joystick");
  }
#endif

  /* set up mapping for coordinates to directions */
  __jlib_joys[which].x1   = l;  
  __jlib_joys[which].y1   = t;
  __jlib_joys[which].x2   = r;
  __jlib_joys[which].y2   = b;
  __jlib_joys[which].xcen = x_cen;
  __jlib_joys[which].ycen = y_cen;

  /* set dead zone size as +/- 6.25% of stick centre */
  __jlib_joys[which].deadx1 = x_cen - ((x_cen - __jlib_joys[which].x1) >> 4);
  __jlib_joys[which].deadx2 = x_cen + ((__jlib_joys[which].x2 - x_cen) >> 4);
  __jlib_joys[which].deady1 = y_cen - ((y_cen - __jlib_joys[which].y1) >> 4);
  __jlib_joys[which].deady2 = y_cen + ((__jlib_joys[which].y2 - y_cen) >> 4);
}


/*+------------------------------------------------------------------------+*/
/*| Convert raw joystick values into a direction.                          |*/
/*+------------------------------------------------------------------------+*/
int joystick_get_direction(int which,int x_axis,int y_axis)
{
 int dir = JOY_CENTER;

#ifndef JLIB_PRODUCTION
  if((which < 1) || (which > 2) || (which > __jlib_num_joysticks)){
    jlib_exit("Invalid joystick");
  }
#endif

 /* should we check for being > x1, < x2 etc also? */
 if (x_axis < __jlib_joys[which].deadx1) dir |= JOY_EAST;
 if (x_axis > __jlib_joys[which].deadx2) dir |= JOY_WEST;
 if (y_axis < __jlib_joys[which].deady1) dir |= JOY_NORTH;
 if (y_axis < __jlib_joys[which].deady1) dir |= JOY_SOUTH;

 return dir;
}

#endif

