#include <jlib.h>
#include <jx_font.h>

/* shows the combinations of simple textured font drawing types */

int main(int argc ,char **argv)
{
 font *f;
 buffer_rec *offscreen,*texture;
 int i;
 image *tex;

 JLIB_DEBUG_ON;

 if (argc != 4) {
    puts("fonttst2 <font> <texture> <text> : draws some <text> in <font> with a <texture>\n<texure> should be a 64x64 (or bigger) PCX file.");
    exit(0);
 }

 screen_set_video_mode();

 /* load and check font */
 f=font_load(argv[1]);
 if(f==NULL){
    jlib_exit("font load failed");
 }

 /* load texture */
 if((tex=image_load_pcx(argv[2])) == NULL) {
    jlib_exit("image load failed");
 }

 screen_block_set_pal(IMG_PALETTE(tex));

 offscreen=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 texture=buff_init(IMG_WIDTH(tex),IMG_HEIGHT(tex));

 /* copy texture pcx into a buffer */
 buff_blit_img_to(texture,0,0,tex,0,0,IMG_MAX_X(tex),IMG_MAX_Y(tex));

 /* draw textured */
 font_string(f,offscreen,0,0,argv[3],15,texture,FONT_TEXTURE);

 screen_blit_fs_buffer(offscreen);
 getch();

 /* then stamped/texured */
 buff_fill(offscreen,15); /* to show stamping */
 font_string(f,offscreen,0,0,argv[3],15,texture,FONT_STAMP|FONT_TEXTURE);

 screen_blit_fs_buffer(offscreen);
 getch();

 buff_clear(offscreen);

 /* draw stencilled,underlined & textured */
 font_string(f,offscreen,0,0,argv[3],15,texture,FONT_UNDERLINE|FONT_TEXTURE);

 screen_blit_fs_buffer(offscreen);
 getch();
 buff_clear(offscreen);

 /* then stamped,underlined & textured */
 buff_fill(offscreen,15); /* to show stamping */
 font_string(f,offscreen,0,0,argv[3],15,texture,FONT_STAMP|FONT_UNDERLINE|FONT_TEXTURE);

 screen_blit_fs_buffer(offscreen);
 getch();

 screen_restore_video_mode();
 return 1;
}
