/**  asctime.c ***********************************************************

     C-Locales handling for DOS / Windows.
     localized asctime(), ctime().
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include <time.h>
#include <stdio.h>

#include "_locale.h"

char *asctime(const struct tm *tp)
{
 static char buf[26];
 sprintf(buf, "%3.3s %3.3s %2d %02d:%02d:%02d %d\n",
      _lc_Wday_[0][tp->tm_wday],
           _lc_Month_[0][tp->tm_mon],
                             tp->tm_mday,
                                  tp->tm_hour,
                                       tp->tm_min,
                                            tp->tm_sec,
                                               tp->tm_year + 1900);
 return buf;
}

char *ctime(const time_t *timer) { return asctime(localtime(timer)); }

/* end of asctime.c */
