/**  doslocal.c **********************************************************

     C-Locales handling for DOS / Windows.
     Encoding of locales values: _lc_str2cp_(), _lc_cp2str_().
     Obtaining localisation tables from DOS: _dos_getLC_().

                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include "__win.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "_locale.h"

#if !defined(_Windows) || defined(USE_OLENLS)
#ifdef USE_OLENLS
#if LOCALE_USER_DEFAULT != _lcn_DEF_
#error Wrong value of _lcn_DEF_
#endif
#endif

#if LCS_ != 8
#error Bad value of LCS_
#endif

unsigned long _lc_str2lid_(const char *str)
{
 if (str[0] == 'C' &&
    (str[1] == ' ' || str[1] == '\0')) return _lcn_C_;
{
#ifdef   USE_OLENLS
 char       *endp;
 unsigned long rv = strtoul(str, &endp, 16);
 if (endp != str+8 || *endp && *endp != lcBRK_) return _lcn_BAD_;
#ifdef   __WIN32__
 if (!IsValidLocale(rv =
      ConvertDefaultLocale(rv), LCID_INSTALLED)) return _lcn_BAD_;
#else
 if (rv == LOCALE_USER_DEFAULT) return GetUserDefaultLCID();
 if (rv == LOCALE_SYSTEM_DEFAULT) return GetSystemDefaultLCID();
#endif
 return rv;
#else    /* DOS */
 ldiv_t dd;
 if ((unsigned long)(dd.rem = atol(str)) > 99999999ul)
   return _lcn_BAD_;
 dd = ldiv(dd.rem, 10000L);
 if ((unsigned)dd.rem  == 9999) dd.rem  = 0xfffful;
 if ((unsigned)dd.quot == 9999) dd.quot = 0xfffful;

 return (unsigned short)dd.rem | dd.quot << 16;
#endif
}
}

void _lc_lid2str_(char *str, unsigned long ccp)
{
 if (ccp == _lcn_C_) strcpy(str, _lcs_C_);
 else
#ifdef   USE_OLENLS
    sprintf(str, ccp == _lcn_BAD_? "????????": "%08lX", ccp);
#else    /* DOS */
   {
#define cpSH ((short*)&ccp)
    if (cpSH[0] == (short)0xffff) cpSH[0] = 9999;
    if (cpSH[1] == (short)0xffff) cpSH[1] = 9999;
    ccp = cpSH[0] + cpSH[1] * 10000L;
#undef  cpSH
    sprintf(str, ccp > 99999999ul? "????????": "%08lu", ccp);
   }
#endif
}

#ifndef  _Windows

int _dos_getLC_(unsigned table, void far *buf, int bufsiz,
                unsigned long ccp)
{
 __asm {
        mov  ax, table
        mov  bx, word ptr ccp[0]  /* BX = code page */
        mov  cx, bufsiz
        mov  dx, word ptr ccp[2]  /* DX = country   */
        push di
        les  di, dword ptr buf
        mov  ah, 65h
        int  21h
        pop  di
        jc   Error
       }
 return  0;
Error:
 return -1;
}
#endif /*_Windows*/
#endif /*_Windows OLENLS*/
/* end of doslocal.c */
