/*******************************************************************
 * fmtnumb() - Formatting number using locale conventions          *
 *                       Copyright (c) 1996  by Timofei Bondarenko *
 *******************************************************************/
#include <ctype.h>
#include <string.h>
#include <locale.h>

#ifndef __BORLANDC__
char *stpcpy(char *dst, const char *src)
{
 size_t xx = strlen(src);
 memcpy(dst, src, xx + 1);
 return dst + xx;
}
#endif

#define LCONV_UNDEFINED '\xC0'

/* val - number "[-+ ][0-9][.[0-9]]" to be formatted as mode:
   0 - integer, 1 - local currency,  2 - international currency.
   Result - in buff; return it's length or <0 on errors. */

int fmtnumb(char *buff, const char *val, int mode, const struct lconv *lc)
{
 char *bf, currs[10]; /* currency symbol + sign */
 const char *grp, *gsp, *dp, *sign, *curr;
 int sign_p, cs_pre, sep_sp, frac;

 if (mode)
   {
    if (mode == 1)
      curr = lc->currency_symbol,
      frac = lc->frac_digits;
    else
      curr = lc->int_curr_symbol,
      frac = lc->int_frac_digits;
    dp  = lc->mon_decimal_point;
    grp = lc->mon_grouping;
    gsp = lc->mon_thousands_sep;

    if (*val == '-')
      sign = lc->negative_sign,
      sign_p = lc->n_sign_posn,
      cs_pre = lc->n_cs_precedes,
      sep_sp = lc->n_sep_by_space;
    else
      sign = lc->positive_sign,
      sign_p = lc->p_sign_posn,
      cs_pre = lc->p_cs_precedes,
      sep_sp = lc->p_sep_by_space;
   }
 else
   {
    dp  = lc->decimal_point;
    grp = lc->grouping;
    gsp = lc->thousands_sep;
    sign = *val == '-'? "-": "";
    curr = "";
    sign_p = 1;
    frac = cs_pre = sep_sp = LCONV_UNDEFINED;
   }

 bf = currs; /* making currency symbol with optional sign */
 if (sign_p == 3) bf = stpcpy(bf, sign);
 bf = stpcpy(bf, curr);
 if (sign_p == 4) bf = stpcpy(bf, sign);
 *bf = '\0';

 bf = buff;  /* making currency symbol + value + sign */
 if (sign_p == 1) bf = stpcpy(bf, sign);
 else if (sign_p == 0) *bf++ = '(';
 if (cs_pre == 1)
   {
    bf = stpcpy(bf, currs);
    if (sep_sp == 1) *bf++ = ' ';
   }

 if ((mode = *val) == '-' || mode == '+' || mode == ' ') val++;
 mode = 0;
 while(isdigit(*(unsigned char*)val)) bf[mode++] = *val++;
 if (*val && *val++ != '.') return -1;
 else
   {
    int sep = strlen(gsp),
        exp = 1, cg;
    while((cg = *grp) && mode > cg && !(cg & LCONV_UNDEFINED))
      {
       mode -= cg;
       memmove(bf + mode + sep, bf + mode, exp += cg);
       memcpy(bf + mode, gsp, sep); exp += sep;
       if (grp[1]) grp++;
      }
    bf += exp + mode - 1;
   }
 if (*dp && frac)
   {
    bf = stpcpy(bf, dp);
    if (frac & LCONV_UNDEFINED) frac = -1;
    while(isdigit(*(unsigned char*)val) && frac--)
      *bf++ = *val++; /* NO ROUNDING!!! */
    if (frac > 0)
      {
       if (*val) return -1;
       while(frac--) *bf++ = '0';
   }  }

 if (cs_pre == 0)
   {
    if (sep_sp == 1) *bf++ = ' ';
    bf = stpcpy(bf, currs);
   }
 if (sign_p == 2) bf = stpcpy(bf, sign);
 else if (sign_p == 0) *bf++ = ')';

 *bf = '\0';
 return (int)(bf - buff);
}

/* end of fnumb.c */