/**  lc_chars.c **********************************************************

     C-Locales handling for DOS / Windows.
     LC_CTYPE & LC_COLLATE
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include "__win.h"
#include <ctype.h>
#include <string.h>
#include "_locale.h"

/* WARNING: code in this file is very tangled. That is right, because
   different tables obtained from DOS/Windows are provides incomplete
   information and contains the lots of bugs.
   We can't to change them or use particular patches because the tables
   are unpublic and the bugs are OS-version dependent.
   Ofcourse, This code is hard-to-read (or readless at all)
   but it avoiding most of these bugs very well.
   Don't change it if you aren't sure...
 ******************* Don't touch!   That's works *****************/

     /****** definition of the mobile flags for _ctype[] ******/

typedef unsigned char ctype_t;

#define CtypeT    ((ctype_t*)_ctype+1)
#define CTYPE(xx) ((xx >= 0x80 ? cType2 : CtypeT)[xx])

#if   defined(__BORLANDC__)
#define _lc_LOW  ((ctype_t)_IS_LOW)
#define _lc_UPP  ((ctype_t)_IS_UPP)
#define _lc_PUN  ((ctype_t)_IS_PUN)
#define _lc_CTL  ((ctype_t)_IS_CTL)
#define _lc_SPC  ((ctype_t)_IS_SP)   /* Only if USE_OLENLS  */
#define _lc_DIG  ((ctype_t)_IS_DIG)  /* currently not used  */
#elif defined(_MSC_VER)
#define _lc_LOW  ((ctype_t)_LOWER)
#define _lc_UPP  ((ctype_t)_UPPER)
#define _lc_PUN  ((ctype_t)_PUNCT)
#define _lc_CTL  ((ctype_t)_CONTROL)
#define _lc_SPC  ((ctype_t)_SPACE)   /* Only if USE_OLENLS  */
#define _lc_DIG  ((ctype_t)_DIGIT)   /* currently not used  */
#else
#define _lc_LOW  ((ctype_t)islower('z'))  /*_lc_ctype[2] islower */
#define _lc_UPP  ((ctype_t)isupper('Z'))  /*_lc_ctype[3] isupper */
#define _lc_PUN  ((ctype_t)ispunct('.'))  /*_lc_ctype[4] ispunct */
#define _lc_CTL  ((ctype_t)iscntrl( 0 ))  /*_lc_ctype[5] iscntrl */
#define _lc_SPC  ((ctype_t)isspace(' '))  /* Only if USE_OLENLS  */
#define _lc_DIG  ((ctype_t)isdigit('0'))  /* currently not used  */
#endif
#define _lc_ctype_INIT ctype_t _lc_LUP = _lc_LOW|_lc_UPP|_lc_PUN
                       /* Can be modified locally */

#ifdef   _Windows
#ifdef   USE_OLENLS
#ifndef  SORT_STRINGSORT
#define  SORT_STRINGSORT 0x1000
#endif
#define  CompStr(aa,bb) (CompareStringA(intl, \
       SORT_STRINGSORT | NORM_IGNORENONSPACE, \
                                        aa, -1, bb, -1) - 2)
#else  /*USE_OLENLS*/
#define  CompStr         lstrcmp
#endif

#ifndef  _LC_WIN
static void dos_2_win(char *s) { if (!_lc_Win) OemToAnsi(s, s); }
static void win_2_dos(char *s) { if (!_lc_Win) AnsiToOem(s, s); }
#elif    _LC_WIN
#define     dos_2_win(s)
#define     win_2_dos(s)
#else /*!_LC_WIN*/
#define     dos_2_win(s)                       OemToAnsi(s,s)
#define     win_2_dos(s)                       AnsiToOem(s,s)
#endif /*_LC_WIN defined*/
#endif /*_Windows*/

#ifndef  USE_OLENLS

static void buildCtype(ctype_t       *cType2,
                       unsigned char *toLowt, /*   may be NULL */
#ifdef   _Windows
                       unsigned char *toUppt, /* newer be NULL! */
                 const unsigned char *collat)
{ int ii;
 _lc_ctype_INIT;
 unsigned char oa[2]; oa[1] = '\0';

 for(ii = 0x80; ii < 0x100; ii++)
   {
    toUppt[ii] = oa[0] = ii; dos_2_win(oa);
    if (IsCharUpper(oa[0]))
      {
       cType2[ii] = _lc_UPP;
       if (toLowt)
         {
          AnsiLower(oa);
          win_2_dos(oa);
          toLowt[ii] = oa[0];
      }  }
    else if (IsCharLower(oa[0]))
      {
       cType2[ii] = _lc_LOW;
       AnsiUpper(oa);
       win_2_dos(oa);
       toUppt[ii] = oa[0];
      }
   }
#else  /*_Windows*/
                 const unsigned char *toUppt, int ii,
                 const unsigned char *collat, int len)
{
 _lc_ctype_INIT;

 while(--ii >= 0x80)   /* only second half of toUppt is used */
   {
    int cc;
    if (ii != (cc = toUppt[ii]))
      if (cc >= 0x80)
        {
         cType2[cc] = _lc_UPP;
         cType2[ii] = _lc_LOW;
         if (toLowt) toLowt[cc] = ii;
        }
      else cType2[ii] = isalpha(cc) ? _lc_LOW
                       :ispunct(cc)/* CtypeT[cc] & _lc_PUN*/;
   }
#endif /*_Windows*/

#ifdef   _Windows
 for(ii = 0x80; ii < 0x100; ii++)
#else
 for(ii = 0x80; ii <   len; ii++)
#endif
   if (!cType2[ii])
     {
      int j = 0x100,
          cc = collat[ii],
#if 0 /* expansion of flags */
          mf = 0;
      while(--j >= 0)
        {
         int flg;
         if (cc == collat[j] &&
             (flg = CTYPE(j) & _lc_LUP)) mf |= flg;
        }
#else /* expansion to near flags */
          mf, mp, mn;
     mf = mp = mn = 0;
     while(--j >= 0)
        {
         int flg;
         if (flg = CTYPE(j) & _lc_LUP)
           {
            int clj = collat[j];
                 if (cc == clj)     mf |= flg;
            else if (cc == clj + 1) mp |= flg;
            else if (cc == clj - 1) mn |= flg;
        }  }
      if (!mf) mf = mp & mn;
#endif
      if (mf & _lc_PUN) mf = _lc_PUN; /* only ONE */
      else if (mf & _lc_UPP) mf = _lc_UPP;
      cType2[ii] = mf;
     }
}

#else  /*USE_OLENLS*/

static LCID buildCtype(LCID intl,
                       ctype_t       *cType2,
                       unsigned char *toLowt, /*   may be NULL */
                       unsigned char *toUppt) /* newer be NULL! */
{
 int ii;
 unsigned char  cgtype[0x80];
 unsigned short w_type[0x80];
 _lc_ctype_INIT;

 for(ii = 0x80; ii <= 0xff; ii++) cgtype[ii - 0x80] = ii;
#ifndef _LC_WIN
 if   (!_lc_Win) OemToAnsiBuff(cgtype, cgtype, 0x80);
#elif  !_LC_WIN
                 OemToAnsiBuff(cgtype, cgtype, 0x80);
#endif
 if (FALSE == GetStringTypeA(intl, CT_CTYPE1,
                             cgtype, 0x80, w_type)) return _lcn_BAD_;
 LCMapStringA(intl, LCMAP_UPPERCASE,
              cgtype, 0x80, toUppt + 0x80, 0x80);
 if (toLowt)
 LCMapStringA(intl, LCMAP_LOWERCASE,
              cgtype, 0x80, toLowt + 0x80, 0x80);

#if !defined(_LC_WIN) || !_LC_WIN
#if !defined(_LC_WIN)
 if        (!_lc_Win)
#endif
   {
    AnsiToOemBuff(cgtype,        cgtype,        0x80);
    AnsiToOemBuff(toUppt + 0x80, toUppt + 0x80, 0x80);
    if (toLowt)
    AnsiToOemBuff(toLowt + 0x80, toLowt + 0x80, 0x80);
   }
#endif

 for(ii = 0x80; ii <= 0xff; ii++)
   {
    int ix = w_type[ii - 0x80], iy = 0;

/*  Condition below necessary if !_lc_Win.
    if _lc_Win - used side effect on errors above */
    if (ii == cgtype[ii - 0x80])
      {
       if (ix & C1_UPPER) iy |= _lc_UPP;
       if (ix & C1_LOWER) iy |= _lc_LOW;
       if (ix & C1_PUNCT) iy |= _lc_PUN;
       if (ix & C1_SPACE) iy |= _lc_SPC;
       if (ix & C1_CNTRL) iy |= _lc_CTL;
      }
    else
      {
       if (toLowt)
         toLowt[ii] = ii;
       toUppt[ii] = ii;
      }
    cType2[ii] = iy;
   }

 return intl;
}

#endif /*USE_OLENLS*/

#ifdef   _Windows

static void getCollat(
#ifdef   USE_OLENLS
                      LCID intl,
#endif
                      unsigned char *collat)
{
#if !defined(_LC_WIN) || !_LC_WIN
 unsigned char hash_[0x100]; /* temporary hash */
#define    Hoem2win(x)   (hash_[x])
#define SetHoem2win(x,y) (hash_[x] = (y))
#else
#define    Hoem2win(x)   (x)
#define SetHoem2win(x,y) (y)
#endif
 int ii;
 unsigned char aa[2], bb[2]; aa[1] = bb[1] = '\0';

 for(ii = 0; ii < 0x100; ii++)
   {
    aa[0] = ii;    dos_2_win(aa);
    bb[0] = aa[0]; win_2_dos(bb);
    if (bb[0] == ii)
      {
       int jj, weight = 0;
       SetHoem2win(ii, aa[0]);
       for(jj = 1; jj < ii; jj++)  /* '\0' == '\1' !!! */
         if (bb[0] = Hoem2win(jj)) /* == jj) */
           {
            int cv, wg = collat[jj];
            if (cv = CompStr(bb, aa))
              {
               if (cv < 0 && weight <= wg) weight = wg + 1;
              }
            else { weight = wg; goto Break; }
           }
       for(jj = 1; jj < ii; jj++)
         if (weight <= collat[jj]) collat[jj]++;
Break: collat[ii] = weight;
      }
    else collat[ii] = ii, SetHoem2win(ii, '\0');
   }
}
#endif /*_Windows*/

/*-----------------------------------------------------------------------*/

static void rebuildWeight(unsigned char weight[0x100],
                          unsigned char collat[0x100],
                          int min, int max, int add)
{
 int ii;
 memset(weight, 0, 0x100);
 for(ii = 0; ii < 0x100; ii++)
   {
    int fx;
    if (max > (fx = collat[ii]) &&
        min <= fx) collat[ii] = fx += add;
    weight[fx]++;
   }
}

static void buildColl(const ctype_t *cType2, /* second half */
                      unsigned char *collat) /* [0x100]     */
{
 unsigned ii;
 unsigned char weight[0x100];
 _lc_ctype_INIT
#ifdef   USE_OLENLS
               | _lc_SPC
#endif
               | _lc_CTL;

 rebuildWeight(weight, collat, 0, 0, 0);

 for(ii = 0; ii < 0x100; ii++)
   {
    unsigned char lmf = _lc_LOW;

    if (!weight[ii])
      {
       int nw = ii;
       do if (++nw >= 0x100) goto Break;
       while(!weight[nw]);            /* 0x100 */
       rebuildWeight(weight, collat, nw, nw +1, ii - nw);
      }

    while(weight[ii] > 1)
      {
       int ci = ii, fc;   /* cleaning the next weight */
       do if (++ci >= 0x100) goto Break;
       while(weight[ci]);
       if (ci - ii > 1)
         rebuildWeight(weight, collat, ii +1, ci, 1);

       fc = 0;
       for(ci = 0xff; ci >= 0; ci--) /* what types are presents? */
         {
          int fx;
          if (ii == collat[ci] &&
              (fx = CTYPE(ci) & _lc_LUP))
            if (fx & _lc_CTL)
              {          /* full resolving of Control characters */
               weight[ii]--;
               weight[++collat[ci]]++;
               goto Continue;
              }
            else fc |= fx;
         }

       if (!(fc & lmf)) lmf = _lc_UPP;
       if (!(fc & lmf) || !(fc & ~lmf)) break;
                 /* resolving by case (UPP/LOW) */
       for(ci = 0; ci < 0x100; ci++)
         if (ii == collat[ci] &&
             lmf == (_lc_LUP & CTYPE(ci)))
           {
            weight[ii]--;
            weight[++collat[ci]]++;
           }
       if (lmf == _lc_UPP) break;
       else lmf = _lc_UPP; /* optional - to avoid bad CTYPEs */
Continue: ;
      }
   }
Break: ;
}

static void buildColl_i(const unsigned char *igncase2, int si)
{
 unsigned char weight[0x100];

 memcpy(_lc_collati + si, _lc_collate + si, 0x100 - si);
 while(si-- > 0)
   _lc_collati[si] =
   _lc_collate[(si < 0x80 ? _lc_toupper
                          : igncase2)[si]];
 rebuildWeight(weight, _lc_collati, 0, 0, 0);
 si = 0;
 do if (++si >= 0x100) return;
 while(weight[si]);
 if (si > 1)
   rebuildWeight(weight, _lc_collati, 1, si, 1);
}

/*-----------------------------------------------------------------------*/
#if !defined(_Windows)

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 unsigned ii;
 struct _dos_LCT_ dlt;

 if (ccp != _lcn_C_)
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(1, &dli, sizeof(dli), ccp) ||
        0 > _dos_getLC_(2, &dlt, sizeof(dlt), ccp =
                                 catLID(dli))) return _lcn_BAD_;
   }
 memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
 for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                  _lc_tolower[ii] = ii;
 if (ccp != _lcn_C_)
   {
    if ((ii = dlt.t->size) > 0x80) ii = 0x80;
    memcpy(_lc_toupper + 0x80, dlt.t->t, ii);
    if (0 > _dos_getLC_(6, &dlt, sizeof(dlt), ccp)) ii = 0;
    else if ((ii = dlt.t->size) > 0x100) ii = 0x100;
    buildCtype(CtypeT, _lc_tolower,
                       _lc_toupper, 0x100, dlt.t->t, ii);
   }
 return ccp;
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 unsigned ii = 0;
 struct _dos_LCT_ dlt;

 if (ccp != _lcn_C_)
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(1, &dli, sizeof(dli), ccp) ||
        0 > _dos_getLC_(6, &dlt, sizeof(dlt), ccp =
                                 catLID(dli))) return _lcn_BAD_;
    if ((ii = dlt.t->size) > 0x100) ii = 0x100;
    memcpy(_lc_collate, dlt.t->t, ii);
   }
 for(_lc_collate[0] = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;

 if (ccp != _lcn_C_)
   {
    ctype_t cType2[0x80];
    memset(cType2, 0, sizeof(cType2));
    if (0 > _dos_getLC_(2, &dlt, sizeof(dlt), ccp)) ii = 0;
    else if ((ii = dlt.t->size) > 0x80) ii = 0x80;
    buildCtype(cType2 - 0x80, NULL,
               dlt.t->t - 0x80, ii += 0x80,
               _lc_collate, 0x100);
    buildColl(cType2 - 0x80, _lc_collate);
    buildColl_i(dlt.t->t - 0x80, ii);
   }
 else buildColl_i(_lc_toupper, 0x80);
 return ccp;
}

#elif !defined(USE_OLENLS)

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 int ii;

 if (ccp != _lcn_C_ && ccp != _lcn_DEF_) return _lcn_BAD_;
 memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
 for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                  _lc_tolower[ii] = ii;
 if (ccp != _lcn_C_)
   {
    unsigned char collat[0x100];
    getCollat(collat);
    buildCtype(CtypeT, _lc_tolower,
                       _lc_toupper, collat);
   }
 return ccp;
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 int ii;

 if (ccp != _lcn_C_ && ccp != _lcn_DEF_) return _lcn_BAD_;

 for(ii = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;

 if (ccp != _lcn_C_)
   {
    unsigned char igncase2[0x80];
    ctype_t         cType2[0x80];
    memset(cType2, 0, sizeof(cType2));
    getCollat(_lc_collate);
    buildCtype(cType2 - 0x80, NULL, igncase2 - 0x80, _lc_collate);
    buildColl(cType2 - 0x80, _lc_collate);
    buildColl_i(igncase2 - 0x80, 0x100);
   }
 else buildColl_i(_lc_toupper, 0x80);

 return ccp;
}

#else  /*USE_OLENLS*/

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_)
   {
    int ii;
    memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
    for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                     _lc_tolower[ii] = ii;
    return ccp;
   }
 return buildCtype(ccp, CtypeT, _lc_tolower, _lc_toupper);
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 int ii;
 unsigned char igncase2[0x80];
 ctype_t         cType2[0x80];

 if (ccp == _lcn_C_)
   {
    for(ii = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;
    buildColl_i(_lc_toupper, 0x80);
   }
 else if (_lcn_BAD_ != (ccp = buildCtype(ccp,
                        cType2 - 0x80, NULL, igncase2 - 0x80)))
   {
    getCollat(ccp, _lc_collate);
    buildColl(cType2 - 0x80, _lc_collate);
    buildColl_i(igncase2 - 0x80, 0x100);
   }
 return ccp;
}

#endif /*USE_OLENLS*/

/* end of lc_chars.c */
