/**  lc_time.c ***********************************************************

     C-Locales handling for DOS / Windows.
     LC_TIME
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include "__win.h"
#include "_locale.h"

#ifndef  _Windows  /* DOS */

static const char dmy_c[ ] = "%a %e %b %X %Y",
                  uni_c[ ] = "%x %X";
static       char uni_x[3][9] = { "%m %d %y", "%d %m %y", "%y %m %d" },
                  uni_X[ ] = "%H:%M:%S%p";

LC_ID_ _lc_time_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_) _lc_Fmt_ = _lc_Txt_ = 0;
 else
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(1, &dli, sizeof(dli), ccp)) return _lcn_BAD_;
    ccp = catLID(dli);
    _lc_Fmt_ = 1;
    _lc_fmt_c_[1] = uni_c;
    if (_lc_Txt_ = dli.codepage == 866 && /* Russian */
                   dli.country == 007) _lc_fmt_c_[1] = dmy_c;
    else switch(dli.country)
           {
         case   1: /* USA */
         case   4: /* Canada Eng. */
         case  44: /* UK  */
         case  61: /* Eglish Int. */
         case  64: /* New Zealand */
                 if (dli.date_f == 0) _lc_fmt_c_[1] = _lc_fmt_c_[0];
            else if (dli.date_f == 1) _lc_fmt_c_[1] = dmy_c;
         default: break;
           }

    if (dli.date_f > 2) dli.date_f = 0;
    _lc_fmt_x_[1] = uni_x[dli.date_f];
    uni_x[dli.date_f][2] =
    uni_x[dli.date_f][5] = dli.date_sep[0];

    _lc_fmt_X_[1] = uni_X;
    if (dli.hours)
      uni_X[1] = 'H', uni_X[8] = '\0';
    else
      uni_X[1] = 'I', uni_X[8] = '%';
    uni_X[2] = uni_X[5] = dli.time_sep[0];
   }
 return ccp;
}

#else             /* _Windows */

#include <string.h>

struct NamEntry { const char **dst;
                  const char **def;
                  unsigned   count,
                             ident;
                };

static const char Wfmt[] = "dMyg" /* (g=Era is not allowed) Win date format */
#ifdef   USE_OLENLS
                               "hHmst" /* Win time format */
#endif
/***********************/;
static const char WtoU[] = "ddaA""mmbB""yyYY""????"
                               /* ^ - ? month 1...12 */
                         /* ^ - e? day 1...31 withut leading ' ' */
#ifdef   USE_OLENLS
                           "IIIIHHHHMMMMSSSSpppp"
#endif
/***********************/;
#ifdef   USE_OLENLS
#define STRTERM  0
#define GETcfgSTR(id,buf,max)  GetLocaleInfoA(ccp,id,buf,max)
#define buildTabs(buf)         buildTabs_(buf,ccp)
#define fmt_int(buf,entry)     fmt_int_(buf,entry,ccp)
#define COMPAT31 0
#else
static const char Intl[] = "Intl",
                  empty[] = "";
#define STRTERM  1
#define GETcfgSTR(id,buf,max)  GetProfileString(Intl,id,empty,buf,max)

#define COMPAT31 1 /* 1 or 0 */
#if     COMPAT31
#include <olenls.h>
#undef  LOCALE_S1159
#undef  LOCALE_S2359
#undef  LOCALE_SSHORTDATE
#undef  LOCALE_SLONGDATE
#endif
#define LOCALE_S1159       "s1159"
#define LOCALE_S2359       "s2359"
#define LOCALE_SSHORTDATE  "sShortDate"
#define LOCALE_SLONGDATE   "sLongDate"

static const struct NamEntry   main_cpl[] =
      {
       { _lc_Wday_ [1],  _lc_Wday_ [0],  7, 260 }
      ,{ _lc_Month_[1],  _lc_Month_[0], 12, 276 }
#ifdef  WIN_ABBR_LC
      ,{ _lc_WdayS,      _lc_Wday_ [1],  7, 267 }
      ,{ _lc_MonthS,     _lc_Month_[1], 12, 288 }
#endif
      };
#define MAIN_CPL_SIZE (sizeof(main_cpl)/sizeof(main_cpl[0]))
#define MAIN_CPL_ABBR 2
#endif

#if defined(USE_OLENLS) || COMPAT31

static const struct NamEntry olenls_dll[] =
      {
       { _lc_Wday_[1],   _lc_Wday_[0],   1, LOCALE_SDAYNAME7         }
      ,{ _lc_Wday_[1]+1, _lc_Wday_[0]+1, 6, LOCALE_SDAYNAME1         }
      ,{ _lc_Month_[1],  _lc_Month_[0], 12, LOCALE_SMONTHNAME1       }
#ifdef  WIN_ABBR_LC
      ,{ _lc_WdayS,      _lc_Wday_[0],   1, LOCALE_SABBREVDAYNAME7   }
      ,{ _lc_WdayS+1,    _lc_Wday_[0]+1, 6, LOCALE_SABBREVDAYNAME1   }
      ,{ _lc_MonthS,     _lc_Month_[0], 12, LOCALE_SABBREVMONTHNAME1 }
#endif
      };
#define OLENLS_DLL_SIZE (sizeof(olenls_dll)/sizeof(olenls_dll[0]))
#define OLENLS_DLL_ABBR 3
#endif

#ifdef   USE_OLENLS
static void buildTabs_(char **buf, LCID ccp)
#else
static void buildTabs (char **buf)
#endif
{
 char *sb = *buf;
#ifdef   USE_OLENLS
 const struct NamEntry *elst = olenls_dll;
 int    SizeIdx = OLENLS_DLL_SIZE;
#define AbbrIdx   OLENLS_DLL_ABBR
#else /*USE_OLENLS*/
 UINT err_mode = SetErrorMode(SEM_NOOPENFILEERRORBOX|
                              SEM_FAILCRITICALERRORS);
 const struct NamEntry *elst = main_cpl;
 int    SizeIdx = MAIN_CPL_SIZE;
 HINSTANCE lib;
#if      COMPAT31
#ifdef   WIN_ABBR_LC
 int    AbbrIdx = MAIN_CPL_ABBR;
#endif
 int WINAPI (*GetLocaleInfoP)(LCID, LCTYPE, char FAR*, int) = NULL;

 if (HINSTANCE_ERROR <= (lib = LoadLibrary("ole2nls.dll")))
   if ((FARPROC)GetLocaleInfoP = GetProcAddress(lib, "GetLocaleInfoA"))
     {
      elst = olenls_dll;
      SizeIdx = OLENLS_DLL_SIZE;
#ifdef   WIN_ABBR_LC
      AbbrIdx = OLENLS_DLL_ABBR;
#endif
     }
   else FreeLibrary(lib);
 if (!GetLocaleInfoP)
#else  /*COMPAT31*/
#define AbbrIdx  MAIN_CPL_ABBR
#endif /*COMPAT31*/
                        lib = LoadLibrary("main.cpl");
 SetErrorMode(err_mode);
 if (HINSTANCE_ERROR > lib)
   {
    _lc_Txt_ = 0; return;
   }
#endif /*USE_OLENLS*/
 _lc_Txt_ = 1;

 while(SizeIdx--)
   {
    unsigned count;
    for(count = 0; count < elst->count; count++)
      {
       int len;
       elst->dst[count] = sb;
       len =
#ifdef   USE_OLENLS
             GetLocaleInfoA(ccp, elst->ident + count, sb, 24);
#else
#if      COMPAT31
             GetLocaleInfoP?
             GetLocaleInfoP(LOCALE_USER_DEFAULT,
                                  elst->ident + count, sb, 24):
#endif
             (1 + LoadString(lib, elst->ident + count, sb, 24));
#endif     /* ^ len without '\0' */

       if (len > 1) sb += len;
#ifdef  WIN_ABBR_LC
       else if (SizeIdx < AbbrIdx)
         {
          strcpy(sb, elst->def[count]); sb += 4; sb[-1] = '\0';
         }
#endif
       else elst->dst[count] = elst->def[count];
      }
    elst++;
   }
#ifndef  USE_OLENLS
 FreeLibrary(lib);
#undef   AbbrIdx
#endif
 *buf = sb;
}

#ifdef   USE_OLENLS
static int fmt_int_(char *fmt, LCTYPE entry, LCID ccp)
#else
static int fmt_int (char *fmt, const char *entry)
#endif
{
 char buf_[128], *buf, *ft = fmt;

 if (GETcfgSTR(entry, buf = buf_, sizeof(buf_)-1))
   while(*buf)
     {
      const char *tms;
      int ch;

      if (*buf == '\'')
        while(ch = *ft = *(++buf))
          {
           if (ch == '%') *(++ft) = '%';
           else if ('\'' == ch &&
                    '\'' != *(++buf)) break;
           ft++;
          }
      else if (tms = strchr(Wfmt, ch = *buf))
        {
         int ii = 0;
         while(ch == *(++buf)) if (ii < 3) ii++;
         *ft++ = '%';      /*^ && ^*/
         *ft++ = WtoU[ii + ((int)(tms - Wfmt) << 2)];
        }
      else if ('%' == (*ft++ = *buf++)) *ft++ = '%';
     }
 if (ft != fmt) *ft = '\0'; /* Don't destroy an old value */
 return (int)(ft - fmt);
}

LC_ID_ _lc_time_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_) _lc_Fmt_ = _lc_Txt_ = 0;
#ifndef  USE_OLENLS
 else if (ccp != _lcn_DEF_) return _lcn_BAD_;
#endif
 else
   {
#ifdef   WIN_ABBR_LC
    static char sbuf[386]; /* Not checked : 300 ... */
#else
    static char sbuf[256]; /* Not checked : 300 ... */
#endif
    char *buf = sbuf;
    int ii;
#ifndef  USE_OLENLS
    _lc_fmt_X_[1] = buf;
    *buf++ = '%';
    *buf++ = (_lc_Fmt_ = GetProfileInt(Intl, "iTime", 1))? 'H': 'I';
/* _lc_Fmt_ is temporary used as iTime */
    {
     int  gb, gt;
     char tmb[8];
     GetProfileString(Intl, "sTime", ":", tmb, sizeof(tmb)-1);
     for(gb = gt = 0; buf[gb] = tmb[gt]; gb++, gt++)
       if (tmb[gt] == '%') buf[++gb] = '%';
     strcpy(buf + gb + 2, buf);
     buf += gb; *buf++ = '%'; *buf++ = 'M';
     buf += gb; strcpy(buf, "%S%p"); buf += 5;
    }
#else  /*USE_OLENLS*/
    if (ii = fmt_int(buf, LOCALE_STIMEFORMAT))
      _lc_fmt_X_[1] = buf, buf += 1 + ii;
    else return _lcn_BAD_; /*_lc_fmt_X_[1] = _lc_fmt_X_[0];*/
    _lc_Fmt_ = GETcfgSTR(LOCALE_ITIME, buf, 10)? *buf - '0': 0;
/* _lc_Fmt_ is temporary used as iTime */
#endif
    buildTabs(&buf);

    if (ii = GETcfgSTR(LOCALE_S2359, (char*)_lc_AmPm_[1][0] =
                                     (char*)_lc_AmPm_[1][1] = buf, 10))
      buf += ii + STRTERM;
    else if (_lc_Fmt_) *buf++ = '\0';
    else _lc_AmPm_[1][1] = _lc_AmPm_[0][1];

    if (!_lc_Fmt_)
      if (ii = GETcfgSTR(LOCALE_S1159, (char*)_lc_AmPm_[1][0] = buf, 10))
        buf += ii + STRTERM;
      else _lc_AmPm_[1][0] = _lc_AmPm_[0][0];

    if (ii = fmt_int(buf, LOCALE_SSHORTDATE))
      _lc_fmt_x_[1] = buf, buf += 1 + ii;
    else _lc_fmt_x_[1] = _lc_fmt_x_[0];

    if (ii = fmt_int(buf, LOCALE_SLONGDATE))
      {
       _lc_fmt_c_[1] = buf;
       strcpy(buf += ii, " %X"); buf += /*4 last:-1*/3;
      }
    else _lc_fmt_c_[1] = _lc_fmt_c_[0];

#ifndef  _LC_WIN
    if (!_lc_Win) AnsiToOemBuff(sbuf, sbuf, (int)(buf - sbuf));
#elif   !_LC_WIN
                  AnsiToOemBuff(sbuf, sbuf, (int)(buf - sbuf));
#endif
    _lc_Fmt_ = 1;
   }
 return ccp;
}

#endif /*_Windows*/

/* end of lc_time.c */
