/**  locale.c ************************************************************

     POSIX-friendly control of locales for DOS / Windows.

                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/

#include <string.h>
#include "_locale.h"

static LC_ID_ _lc_empty_(LC_ID_ ccp) { return _lcn_C_/*ccp*/; }

const char _lcs_DEF_[] = _DEFlocale_D_,
           _lcs_C_  [] = _DEFlocale_C_;

LC_ID_ (*_lc_fptr_[])(LC_ID_) =
      { _lc_ctype_, _lc_collate_, _lc_time_, _lc_empty_, _lc_empty_ };

char *setlocale(int category, const char *locale)
{
 static int  lc_cat[5] =
       { LC_CTYPE, LC_COLLATE, LC_TIME, LC_NUMERIC, LC_MONETARY };
 static char lc_val[LCS_0 * 5] = _DEFlocale_C_"~"
                                 _DEFlocale_C_"~"
                                 _DEFlocale_C_"~"
                                 _DEFlocale_C_"~"
                                 _DEFlocale_C_;
 if (locale)
   {
    int cat, offs; cat = offs = 0;

    switch(strlen(locale))
      {
    case 0:     locale = _lcs_DEF_;
       break;
    case 1:
#if 1 != LCS_
    case LCS_:
#endif
       break;
    case LCS_0*5-1: if (category != LC_ALL) return NULL;
                offs = LCS_0;
       break;
    default:    return NULL;
      }

    do {
        LC_ID_ ccp;
        if (LC_ALL == category || lc_cat[cat] == category)
          if (_lcn_BAD_ == (ccp = _lc_str2lid_(locale)) ||
              _lcn_BAD_ == (ccp = _lc_fptr_[cat](ccp))) return NULL;
          else _lc_lid2str_(lc_val + LCS_0*cat, ccp);
        locale += offs;
       }
    while(5 > ++cat);
   }

 switch(category)
   {
 case LC_ALL:      lc_val[LCS_0*1-1] = lc_val[LCS_0*2-1] =
                   lc_val[LCS_0*3-1] = lc_val[LCS_0*4-1] = lcBRK_;
                   lc_val[LCS_0*5-1] = 0; locale = lc_val;      break;
 case LC_CTYPE:    lc_val[LCS_0*1-1] = 0; locale = lc_val + 0;    break;
 case LC_COLLATE:  lc_val[LCS_0*2-1] = 0; locale = lc_val + LCS_0; break;
 case LC_TIME:     lc_val[LCS_0*3-1] = 0; locale = lc_val + LCS_0*2; break;
 case LC_NUMERIC:  lc_val[LCS_0*4-1] = 0; locale = lc_val + LCS_0*3; break;
 case LC_MONETARY: lc_val[LCS_0*5-1] = 0; locale = lc_val + LCS_0*4; break;
 default:          return NULL;                             /*  break; */
   }
#if LCS_ > 1
 return (char*)(strcmp(locale, _lcs_C_)? locale: "C");
#else
 return (char*)locale;
#endif
}

/* end of locale.c */
