/**  locale.h ************************************************************

     POSIX-friendly control of locales (locale-dependent formats)
     for DOS / Windows.
                           Copyright (c) 1995,1996  by Timofei Bondarenko
                                           [ e-mail:   tim@ipi.ac.ru ]
 Notes:
  1)   This library can be compiled for 4 different modes:
          a) DOS;
          b) Windows 3.x;
          c) Windows 3.x with ole2nls.dll (Win32s);
          d) Win32.
    These modes works somewhat differently.
    Only 8-bits chararacters are supported.
    See also opt.h! for compile-time options.
  2)   The setlocale() always accepts locales "C" and "".
       For DOS also possible locales like as "CCCCPPPP", where CCCC is
    decimal Country Code and PPPP is decimal Code Page; 9999 is mean
    current or default value i.e. "99999999" is equivalnet to "".
    "00010437" mean USA locale, "00070866" - Russia, etc...
       For Windows 3.x without ole2nls only "C" and "" allowed, where
    "" assume formats from Control Panel which depends of localization
    of Windows, also statement win.ini/Intl/sLanguage=...  can be used.
       For Win32 and Win3x with OLE2NLS setlocale() can accepts
    value of a LCID in form "%08lX", see below _lc_str2lid_() and
    _lc_lid2str_().
  3)   Categories LC_NUMERIC and LC_MONETARY are not linked by default.
    For use them you must make a call of localeconv() at least once
    before setlocale(). This trick save about 10% of codesize and not
    violated other rules. You can call localeconv() in the first line of
    your main() and forget).
  4)   When you change category LC_CTYPE The RTL-table named _ctype
    (or similar) which used in macro isxxxx() and declared in <ctype.h>
    will adjusted.
  5)   For DOS possible only english and russian months and weekdays names,
    because DOS hasn't provide these names but english names are used in
    "C" locale (and therefore are mandatory) and russian is simple my
    native language :)
       For Win3x without ole2nls.dll - thats names accessible in english
    and in one another language dependent from localization of main.cpl.
  6)   For Windows can be used an OEM-charset (by default) or Win-125X -
    charset selected by compile-time or run-time switch _lc_Win
    (see below and opt.h!).
  7)   See below few tables for comparison / conversion of characters.
    Not all of these tables are accessible if USE_OLENLS defined.
  8)   The strcoll() / strxfrm() can do 1- or 2- pass comparison. In case
    of 2-pass the string generated by strxfrm() will be longet than source
    string. See below _lc_Coll2.
  9)   In addition to standard UNIX/POSIX/ANSI-C routines as
    setlocale(), localeconv(), strftime(), strcoll(), strxfrm(),
    toupper(), tolower(), isXXXX()  also
       Provided few non-standard but usable and popular functions:
    strupr(), strlwr(), stricoll(), stricmp(), strnicmp().
       Sorry, scanf() and printf() kinds (dependent on LC_NUMERIC)
    are not implemented...
       Oh, the strfmon() and strptime() will be available in a near future.
  10)  You can to adjust values of categories LC_XXXX according your
    compiler/header/libraries to avoid conflicts between this header
    and your standard <locale.h>.
 *************************************************************************/

#ifndef _LOCALE_H_thin
#define _LOCALE_H_thin

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------
 *****  useful tables for comparison / conversion of characters  *****

  _lc_toupper & _lc_collati   defined by DOS,
  _lc_tolower & _lc_collate   computed from them;

  _lc_toupper & _lc_tolower   determine rules for toupper() and tolower();

  _lc_collate  contains the magic numbers for string sorting
  (_lc_collate[A] < _lc_collate[B] instesd A < B) which must be
  treated as unsigned char;
  _lc_collate  (differ from DOS-source) newer ignore case of character;
  _lc_collati - derived from _lc_collate, always ignore case of character.
  _lc_igncase  is table, used in stricmp(), strnicmp().
  -------------------------------------------------------------------*/

extern unsigned char
        _lc_toupper[256],
        _lc_tolower[256],
        _lc_collate[256],
        _lc_collati[256];
#define _lc_igncase _lc_toupper

#if 0
#if defined(_Windows)
/* You may to correct definition of _lc_Win when locale.lib compiling */
extern int _lc_Win; /* = 1; if != 0 -> WinAnsi else -> OEM */
#endif
#endif
extern int _lc_Coll2; /* if = 1 (default) strcoll()/strxfrm()
    use two pass: first - Case-less and second - Case-sensitive;
                    else if = 0 use single pass (Case-sensitive). */

#ifdef MAKELCID
extern LCID _lc_str2lid_(const char *str);
extern void _lc_lid2str_(char *str, LCID cp);
#endif

/*-------------------------- Common declarations --------------------*/

#if defined(__BORLANDC__) || defined(_MSC_VER)

#define LC_ALL      0
#define LC_COLLATE  1
#define LC_CTYPE    2
#define LC_MONETARY 3
#define LC_NUMERIC  4
#define LC_TIME     5

#else /* UNIX SV, Watcom C */

#define LC_CTYPE    0
#define LC_NUMERIC  1
#define LC_TIME     2
#define LC_COLLATE  3
#define LC_MONETARY 4
/*#define LC_MESSAGES 5*/
#define LC_ALL      6

#endif

#if !defined(__BORLANDC__) || defined(__FLAT__)
#pragma pack(1)
#else
#pragma options -a-
#endif

struct lconv
      {
       char *decimal_point;
       char *thousands_sep;
       char *grouping;
       char *int_curr_symbol;
       char *currency_symbol;
       char *mon_decimal_point;
       char *mon_thousands_sep;
       char *mon_grouping;
       char *positive_sign;
       char *negative_sign;
       char int_frac_digits;
       char frac_digits;
       char p_cs_precedes;
       char p_sep_by_space;
       char n_cs_precedes;
       char n_sep_by_space;
       char p_sign_posn;
       char n_sign_posn;
      };

#if !defined(__BORLANDC__) || defined(__FLAT__)
#pragma pack()
#else
#pragma options -a.
#endif

struct lconv *localeconv(void);

char *setlocale(int category, const char *locale);

#ifdef __cplusplus
           }
#endif
#endif  /*_LOCALE_H_thin*/
/* end of locale.h */