/**  strftime.c **********************************************************

     C-Locales handling for DOS / Windows.
     localized strftime().
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "_locale.h"

#ifndef STRFTIME_EXT
#define STRFTIME_EXT 0
#endif  /* 0/1 - complete UNIX's set of format specifiers = +160 bytes */

size_t strftime(char *str, size_t maxs, const char *fmt, const struct tm *t)
{
 size_t len;

 if (!maxs--) return 0;

 for(len = 0; maxs && *fmt; ++fmt)
   if (*fmt != '%' || *++fmt == '%')
     {
      maxs--;
      str[len++] = *fmt;
     }
   else
     {
      int ii;
      char buf[7 * sizeof(int) / 2]; /* is sufficient for any %d */
      const char *p = buf;
      size_t s_name = 100;

Fmt:  switch(*fmt)    /* Needed to be localized: %c %p %r %x %X */
        {             /* STRFTIME_EXT - not described in POSIX  */
      case  0 : goto FmtEnd;
      case 'a':
#ifdef  WIN_ABBR_LC
         if (_lc_Txt_)
                 { p = _lc_WdayS[t->tm_wday]; break; }
#endif
         s_name = 3;
      case 'A':
         p = _lc_Wday_[_lc_Txt_][t->tm_wday]; break;
      case 'h': /* STRFTIME_EXT */
      case 'b':
#ifdef  WIN_ABBR_LC
         if (_lc_Txt_)
                 { p = _lc_MonthS[t->tm_mon]; break; }
#endif
         s_name = 3;
      case 'B':
         p = _lc_Month_[_lc_Txt_][t->tm_mon]; break;
      case 'c':
         p = _lc_fmt_c_[_lc_Fmt_];
strft:   ii = strftime(str + len, maxs + 1, p, t);
         p = NULL;                      break;
#if     STRFTIME_EXT
      case 'C': /* STRFTIME_EXT */
         ii = t->tm_year / 100 + 19;
#endif
sprn2:   sprintf(buf, "%02u", ii);      break;
      case 'd':
         ii = t->tm_mday;          goto sprn2;
      case 'D': /* STRFTIME_EXT */
         p = "%m/%d/%y";           goto strft;
      case 'e': /* STRFTIME_EXT */
         sprintf(buf, "%2u", t->tm_mday);
                                        break;
#if     STRFTIME_EXT
      case 'E': /* STRFTIME_EXT "Era" for asiates  */
      case 'O': /* STRFTIME_EXT "Alternate digits" */
         fmt++;                    goto   Fmt;
#endif
/*    case 'h':    STRFTIME_EXT see %'b' */
      case 'H':
         ii = t->tm_hour;          goto sprn2;
      case 'I':
         if (!(ii = t->tm_hour % 12)) ii = 12;
                                   goto sprn2;
      case 'j':
         sprintf(buf, "%03u", t->tm_yday + 1);
                                        break;
      case 'm':
         ii = t->tm_mon + 1;       goto sprn2;
      case 'M':
         ii = t->tm_min;           goto sprn2;
#if     STRFTIME_EXT
      case 'n': /* STRFTIME_EXT */
         str[len++] = '\n'; maxs--;  continue;
      case 'N': /* STRFTIME_EXT */
         p = "%a %b %e %T %Z %Y";  goto strft; /* e=>d, T=>H:M:S */
#endif
/*    case 'O': /* STRFTIME_EXT see %'E' "Alternate digits" */
      case 'p':
         p = _lc_AmPm_[_lc_Txt_][t->tm_hour >= 12];
                                        break;
#if     STRFTIME_EXT
      case 'r': /* STRFTIME_EXT */
         p = "%I:%M:%S%p";         goto strft;
      case 'R': /* STRFTIME_EXT */
         p = "%H:%M";              goto strft;
#endif
      case 'S':
         ii = t->tm_sec;           goto sprn2;
#if     STRFTIME_EXT
      case 't': /* STRFTIME_EXT */
         str[len++] = '\t'; maxs--;  continue;
#endif
      case 'T': /* STRFTIME_EXT */
         p = "%H:%M:%S";           goto strft;
      case 'u': /* STRFTIME_EXT */
         if (!(ii = t->tm_wday)) ii = 7;
sprn:    sprintf(buf, "%u", ii);        break;
      case 'U':
         ii = t->tm_wday;           /* 0 = Sunday */
yweek:   ii = (t->tm_yday - ii + 7) / 7;
                                   goto sprn2;
#if     STRFTIME_EXT
      case 'V': /* STRFTIME_EXT  0 = Wednesday ?(Thursday) */
         ii = (t->tm_wday + 4) % 7;
         if (ii <= t->tm_yday)     goto yweek;
         ii = 53;                  goto sprn2;
#endif
      case 'w':
         ii = t->tm_wday;          goto  sprn;
      case 'W':
         ii = (t->tm_wday + 6) % 7; /* 0 = Monday */
                                   goto yweek;
      case 'x':
         p = _lc_fmt_x_[_lc_Fmt_]; goto strft;
      case 'X':
         p = _lc_fmt_X_[_lc_Fmt_]; goto strft;
      case 'y':
         ii = t->tm_year % 100;    goto sprn2;
      case 'Y':
         ii = 1900 + t->tm_year;   goto sprn2;
      case 'Z':
         p = tzname[t->tm_isdst != 0];  break;
      default:
         buf[0] = '\0';                 break;
        } /* end of switch() */

      if (p != NULL)
        {
         ii = strlen(p);
         if (ii > s_name) ii = s_name;
         if (ii > maxs) break;
         memcpy(str + len, p, ii);
        }
      else if (!ii) break;
      len += ii; maxs -= ii;
     } /* end of else, for */

FmtEnd:
 str[len] = '\0';
 return *fmt? 0: len;
}

/* end of strftime.c */
