/**  stricmp.c ***********************************************************

     C-Locales handling for DOS / Windows.
     Locale dependent routines:
     stricmp(), strnicmp().
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include <string.h>
#include "_locale.h"

/*************** Non standard, but useful routines ***************/

int strnicmp(const char *s1, const char *s2, size_t n)
{
 int ci = 0;
 while(n-- && !(ci = (int)_lc_igncase[*(unsigned char*)s1++] -
                     (int)_lc_igncase[*(unsigned char*)s2]) && *s2++);
 return ci;
}

int stricmp(const char *s1, const char *s2)
{
#if 1
 int ci;
 while(!(ci = (int)_lc_igncase[*(unsigned char*)s1++] -
              (int)_lc_igncase[*(unsigned char*)s2]) && *s2++);
 return ci;
#else
 return strnicmp(s1, s2, ~0);
#endif
}

/* end of stricmp.c */
