/**  strxfrm.c ***********************************************************

     C-Locales handling for DOS / Windows.
     Locale dependent routines:
     strxfrm().
                           Copyright (c) 1995,1996  by Timofei Bondarenko
 *-----------------------------------------------------------------------*/
#include <string.h>
#include "_locale.h"

/* strxfrm() - returns length (not including terminating '\0') of buffer
   necessary for s1 to be converted from s2. if that is >= n then s1 is
   undefined; else if n == 0 then s1 is not be changed.
   Therefore reqired buffer size is == 1+strxfrm(NULL, s, 0). */

size_t strxfrm(char *s1, const char *s2, size_t n)
{
 size_t nn = strlen(s2);
 if (_lc_Coll2) nn = (nn << 1) + 1;
 if (nn < n)
   {
    if (_lc_Coll2)
      {
       n = 0; while(*s1++ = _lc_collati[(unsigned char)s2[n++]]);
       s1[-1] = '\1'; /* that's good if _lc_collati  hasn't */
      }               /* contains such ('\1') weight        */
    while(*s1++ = _lc_collate[*(unsigned char*)s2++]);
   }
 return nn;
}

/* end of strxfrm.c */
