// --------------------------------------------------------------------------
//
//  File:      EXPARG.C
//  Product:   MAKEDEP program
//  Author:    Sulyok Pter (C) 1994
//  Compiler:  Borland C\C++ 3.1
//             Borland C\C++ 4.02
//             Microsoft C 6.00A
//             Microsoft C\C++ 7.00
//             Watcom C 9.0
//  Notes:     Expand command line arguments.
//
// --------------------------------------------------------------------------

// Include files ------------------------------------------------------------
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>

// --------------------------------------------------------------------------
//  Name:      exparg
//  Input:     int  *argc                    pointer to argc
//             char ***argv                  pointer to argv[]
//  Output:    int                           0   successful
//                                           -1  not enough memory
//                                           -2  unable to load response file
//  Notes:     Expand command line arguments with loading response file.
// --------------------------------------------------------------------------
int exparg(int *argc, char **argv[])
{
   char **nargv;
   int  nargc, i;
   char wasexpand = 0;

   // Allocate new argv[] array.
   if ( (nargv = (char **)malloc((*argc + 1) * (sizeof(char *)))) == NULL)
      return -1;

   // Copy all argument to new array with expansion.
   for(i=0, nargc=0; i<*argc; i++) {

      // Copy argument.
      if ( (*argv)[i][0] != '@' ) {
         nargv[nargc++] = (*argv)[i];
         } // if

      // Expand response file.
      else {
         int  handle, filesize, argnum, k;
         char *buffer, **tmp;

         // Open response file.
         if ( (handle = open(&((*argv)[i][1]), O_BINARY|O_RDONLY)) == -1) {
            free(nargv);
            return -2;
            } // if
         filesize = filelength(handle);

         // Allocate buffer for response file.
         if ( (buffer = (char *)malloc(filesize+1)) == NULL ) {
            close(handle);
            free(nargv);
            return -2;
            } // if

         // Read entire file to buffer.
         if ( read(handle, buffer, filesize) != filesize ) {
            close(handle);
            free(nargv);
            return -2;
            } // if
         buffer[filesize] = '\0';

         // Close response file.
         close(handle);

         // Separate and count arguments in response file.
         for(k=0, argnum=0; k<filesize; k++) {
            switch( buffer[k] ) {
               case ' ' :
               case '\n':
               case '\r':
               case '\t':
                  buffer[k] = '\0';
                  break;

               default:
                  if ( !k || !buffer[k-1] )
                     argnum++;
                  break;
               } // switch
            } //for

         // Add new items to argv[] array.
         if ( (tmp = (char **)realloc(nargv, ((*argc + 1) + argnum) * sizeof(char *))) == NULL ) {
            free(buffer);
            free(nargv);
            return -1;
            } // if
         nargv = tmp;

         // Register the new arguments.
         k = 0;
         while(k < filesize) {

            // Ignore 0's.
            if ( !buffer[k] ) {
               k++;
               continue;
               } // if

            // Register an argument.
            if ( !k || !buffer[k-1] ) {
               nargv[nargc++] = &buffer[k++];
               continue;
               } // if

            // Else step to next.
            k++;
            } // while

         // Sign the expansion.
         wasexpand = 1;
         } // else

      } // for

   // Set the new arguments.
   if ( wasexpand ) {
      nargv[nargc] = NULL;
      *argc = nargc;
      *argv = nargv;
      } // if
   else
      free(nargv);

   return 0;
}

// End ----------------------------------------------------------------------

