/*
 * 	File msellist.c
 */

#include <stdio.h>
#include <string.h>

#include "mgui.h"

extern void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;
extern void SelectionListCB(MOBJECT p, LIST_SEL *la, void *label);

/***************************************************************
 *	This callback moves all the selected items from a
 *	source list to a destination list
 ***************************************************************/
void MoveItemCB(MOBJECT o, void *o_data, void *adata)
{
	MOBJECT list1 = (MOBJECT )adata;
	LIST_ACT *pi;
	MOBJECT list2 = MObjectGetUserData((MOBJECT )o);
/*
 * Freeze the lists to prevent unnecessary drawing
 */
	MSListFreeze(list1);
	MSListFreeze(list2);
	pi = MSListGetFirstSelectedItem(list1);
	while (pi) {
		MSListAddItem(list2, pi->item, 0L);
		MSListDelItem(list1, pi->item);
		pi = MSListGetNextSelectedItem(list1);
	}
	MSListThaw(list1);
	MSListThaw(list2);
}

/***************************************************************
 *	This callback selects all items in the source list
 ***************************************************************/
void SelectAllCB(MOBJECT o, void *o_data, void *adata)
{
	MOBJECT list = (MOBJECT )adata;
	LIST_ACT *pi;

	pi = MSListGetFirstItem(list);
	MSListFreeze(list);
	while (pi) {
		MSListSelectItem(list, pi->item);
                pi = MSListGetNextItem(list);
	}
	MSListThaw(list);
}

/***************************************************************
 *	This callback deselects all items in the source list
 ***************************************************************/
void DeselectAllCB(MOBJECT o, void *o_data, void *adata)
{
	MOBJECT list = (MOBJECT )adata;
	LIST_ACT *pi;

	pi = MSListGetFirstItem(list);
	MSListFreeze(list);
	while (pi) {
		MSListDeselectItem(list, pi->item);
                pi = MSListGetNextItem(list);
	}
	MSListThaw(list);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void MSelListCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT pbutton, shell, form0, form1, form;
	MOBJECT mslist, slist, sfile, label;
	int i;
	char str[512];

	shell = MCreateShell("Multi Selection List", SF_MODAL);

	form0 = MCreateColForm(shell);

	form = MCreateRowForm(form0);

	form1 = MCreateColForm(form);

	mslist = MCreateSListMultiSel(form1, DEFAULT_FONT, 16, 10, 12);
	MSBLSetHead(mslist, "Nome    Cognome ");
	MSBLHeadSetColor(mslist, seagreen, white);

	slist = MCreateSList(form1, DEFAULT_FONT, 16, 10, 10);
	MObjectSetColor(slist, cadetblue, white);
	MSListSetSortCallback(slist, strcmp);

	form = MCreateColForm(form);
	pbutton = MCreatePButton(form, "Move", TIMES_N_FONT);
/*
 * Store the destination list Object in the push button user data
 * so it can reference the list in the callback
 */
	MObjectSetUserData(pbutton, (void *)slist);
	MPButtonSetCallback(pbutton, MoveItemCB, mslist);
	pbutton = MCreatePButton(form, "Select All", TIMES_N_FONT);
	MPButtonSetCallback(pbutton, SelectAllCB, mslist);
	pbutton = MCreatePButton(form, "Deselect All", TIMES_N_FONT);
	MPButtonSetCallback(pbutton, DeselectAllCB, mslist);
/*
 * Insert 50 items in the source list
 */
	for (i=0; i<50; i++) {
		sprintf(str, "nome%03d cogn%04d", i, i);
		MSListAddItem(mslist, str, (void *)i);
	}
/*
 * Create a SFile to view this source file
 */
	sfile = MCreateSFile(form0, __FILE__,
			(LowRes ? SMALL_FONT : DEFAULT_FONT),
			15, 44);
	MObjectSetColor(sfile, darkblue, white);

	label = MCreateLabel(shell, "", DEFAULT_FONT);
	MSListSetSelectionCallback(mslist, SelectionListCB, label);
	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, CloseDialogCB, 0L);

	MShellRealize(shell);
}
