/*
 * 	File slist.c
 *	Demonstrates the use of the simplest LIST in MGUI library
 */

#include <stdio.h>
#include <string.h>

#include "mgui.h"

extern void CloseDialogCB(MOBJECT p, void *s, void *v);
extern int LowRes;

extern MTColor black, white, darkblue, cadetblue, seagreen;

/***************************************************************
 *	This callback shows the focused item text, position
 *	and user data
 ***************************************************************/
void SelectionListCB(MOBJECT p, LIST_SEL *la, void *label)
{
	static int nn;
	char str[128];

	if (la->pos >= 0)
		sprintf(str, " %c Focused row # %ld <%s> user data: %ld",
			(nn++) & 1 ? '-' : '|',
			la->pos, la->item, (long)la->u_data);
	else
		strcpy(str, "No focused item in the list !");
	MObjectSetText((MOBJECT)label, str);
}

/***************************************************************
 *	This callback shows the activated item text, position
 *	and user data
 ***************************************************************/
void ScrolledListCB(MOBJECT p, LIST_ACT *la, void *v)
{
	char str[128];

	sprintf(str, "Activated row # %ld\n<%s>\nuser data: %ld",
		la->pos, la->item, (long)la->u_data);
	MMessageDialog("", str, "Ok", NULL);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void SListCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT pbutton, shell, form0, form1;
	MOBJECT slist, sfile, label;
	int i;
	char str[512];

	shell = MCreateShell("Scrolled List", SF_MODAL);

	form0 = MCreateColForm(shell);

	form1 = MCreateColForm(form0);

	slist = MCreateSList(form1, DEFAULT_FONT, 16, 10, 12);
	MSListSetCallback(slist, ScrolledListCB, slist);
	MSListSetSortCallback(slist, strcmp);

	MSBLSetHead(slist, "Nome    Cognome");
	MSBLHeadSetColor(slist, seagreen, white);

	for (i=0; i<50; i++) {
		sprintf(str, "nome%03d cogn%04d", i, i);
		MSListAddItem(slist, str, (void *)i);
		if (i == 10)
			MSListSetItemCheckStatus(slist, str, True);
	}
/*
 * Create a SFile to view this source file
 */
	sfile = MCreateSFile(form0, __FILE__,
			(LowRes ? SMALL_FONT : DEFAULT_FONT),
			15, 60);
	MObjectSetColor(sfile, darkblue, white);

	label = MCreateLabel(shell, "", DEFAULT_FONT);
	MSListSetSelectionCallback(slist, SelectionListCB, label);
	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, CloseDialogCB, 0L);
	MObjectSetResize(pbutton, False, False);

	MShellRealize(shell);
}
