/*
 *	File trbutton.c
 *	Demonstrates the use of the RBUTTON and RBUTTON Objects
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

#define N_TOGGLE_BUTTON	4

/*
 *	Callback for closing and destroying a generic dialog
 */
extern void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor	black, white, darkblue, cadetblue, seagreen;

static MOBJECT r_label, t_label;
int		toggle_status[N_TOGGLE_BUTTON];

/*****************************************************
 *	This Callback handles the status change
 *	of a TBUTTON.
 *****************************************************/
void ToggleButtonCB(MOBJECT rb, MVALUE status, void *ii)
{
	char str[128];
	int i;

	toggle_status[(int)ii] = (int)status;
	strcpy(str, "Status: ");
	for (i=0; i < N_TOGGLE_BUTTON; i++)
		strcat(str, (toggle_status[i] ? "  ON" : " OFF"));
/*
 * The LABEL 't_label' is updated with the current status of the toggle
 * buttons as it changes
 */
	MObjectSetText(t_label, str);
}

/*****************************************************
 *	This Callback handles the status change
 *	of a RBUTTON.
 *****************************************************/
void RadioButtonCB(MOBJECT rb, MVALUE status, void *ii)
{
	char str[64];

	if (status) {
/*
 * The LABEL 'r_label' shows which radio button is active
 */
		sprintf(str, "Selected the button %d", (int)ii);
		MObjectSetText(r_label, str);
	}
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void TRButtonCB(MOBJECT obj, void *a, void *b)
{
	int ii;
	char str[16];
	MOBJECT shell, rf, pb, tb, rb, cform, rform, sfile;

	shell = MCreateShell("Toggle & Radio Buttons", SF_MODAL);

	cform = MCreateColForm(shell);
	rform = MCreateRowForm(cform);

	rf = MCreateRowForm(rform);
	for (ii=0; ii < N_TOGGLE_BUTTON; ii++) {
		sprintf(str, "Toggle %d", ii);
/*		tb = MCreateTButton(rf, str, HELV_L_FONT);
*/		tb = MCreateImageTButton(rf, "normal.bmp", "armed.bmp", "unsens.bmp");
		MTButtonSetCallback(tb, ToggleButtonCB, (void *)ii);
	}
	t_label = MCreateLabel(rf, "", DEFAULT_FONT);
/*
 * Activate the last created toggle button
 * (this will also cause the 't_label' text to
 * change accordingly)
 */
	MTButtonActivate(tb);

	rf = MCreateRowForm(rform);
	for (ii=0; ii < 4; ii++) {
		sprintf(str, "Radio %d", ii);
/*		rb = MCreateRButton(rf, str, HELV_L_FONT);
*/		rb = MCreateImageRButton(rf, "normal.bmp", "armed.bmp", "unsens.bmp");
		MRButtonSetCallback(rb, RadioButtonCB, (void *)ii);
	}
	r_label = MCreateLabel(rf, "", DEFAULT_FONT);
/*
 * Activate the last created radio button
 * (this will also cause the 'r_label' text to
 * change accordingly)
 */
	MRButtonActivate(rb);
/*
 * This SFILE Object shows this source file in the dialog
 */
	sfile = MCreateSFile(cform, __FILE__, DEFAULT_FONT, 10, 40);
	MObjectSetColor(sfile, darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
	pb = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pb, CloseDialogCB, 0L);

	MShellRealize(shell);
}
