#include <dos.h>
#include <bios.h>
#include <conio.h>
#include "tcint70.h"

#define IRQ8 0x70
#define SET_EVENT 0x8300
#define CANCEL_EVENT 0x8301
#define LARGEST 0xffff
#define PIT0 0x40
#define PIT2 0x42
#define PITMODE 0x43
#define PITCONST 1193180L
#define KBCTRL 0x61
#define NEW70H 1

static float    tick_per_ms = 1.024;
static float    ms_per_tick = 0.9765625;
static char far *event;
static unsigned char flag70h = 0;
static void     interrupt(*old70h) (__CPPARGS);

volatile unsigned long int ticks_70h;

void            init70h(void)
{
    union REGS      regs;
    struct SREGS    sregs;

    unsigned int    event_seg,
                    event_off;

    if (flag70h != NEW70H) {
        old70h = getvect(IRQ8);
        setvect(IRQ8, new70h);

        event_seg = FP_SEG(event);
        event_off = FP_OFF(event);

        regs.x.ax = SET_EVENT;
        sregs.es = event_seg;
        regs.x.bx = event_off;
        regs.x.cx = LARGEST;
        regs.x.dx = LARGEST;
        int86x(0x15, &regs, &regs, &sregs);

        flag70h = NEW70H;
    }
}

void            quit70h(void)
{
    union REGS      regs;

    if (flag70h == NEW70H) {
        regs.x.ax = CANCEL_EVENT;
        int86(0x15, &regs, &regs);

        setvect(IRQ8, old70h);

        flag70h = 0;
    }
}

void interrupt  new70h(__CPPARGS)
{
    disable();
    ticks_70h++;
    enable();
    old70h();
}

unsigned long   time70h(unsigned long start, unsigned long stop)
{
    unsigned long   duration,
                    millisec;

    if (stop < start)
        return 0;
    else {
        duration = stop - start;
        millisec = duration * ms_per_tick;
        return millisec;
    }
}

void            delay70h(unsigned int delayms)
{
    unsigned long int delaybegin = 0;
    unsigned long int delayend = 0;
    unsigned int    delaytick;

    if (flag70h == NEW70H) {
        delaytick = delayms * tick_per_ms;
        delaybegin = ticks_70h;
        do {
            delayend = ticks_70h;
        } while ((delayend - delaybegin) < delaytick);
    } else {
        delaytick = delayms * 0.0182065;
        biostime(0, (long) &delaybegin);
        do {
            biostime(0, (long) &delayend);
        } while ((delayend - delaybegin) < delaytick);
    }
}

void            sound70h(int freq, int duration)
{
    int             byte;
    unsigned int    freq1;

    freq1 = PITCONST / freq;
    outportb(PITMODE, 0xb6);
    byte = (freq1 & 0xff);
    outportb(PIT2, byte);
    byte = (freq1 >> 8);
    outportb(PIT2, byte);
    byte = inportb(KBCTRL);
    outportb(KBCTRL, (byte | 3));

    delay70h(duration);
    outportb(KBCTRL, (byte & 0xfc));
}
