#include <conio.h>
#include <stdio.h>
#include "tcint8.h"

void            frame(void);

void            main(void)
{
    int             i;
    unsigned long int tick_1,
                    tick_2,
                    elapsedtime;

    frame();

    gotoxy(1, 3);
    cprintf("Initiate PCTIMER: init8h(1000). Start millisecond resolution timing routine.\n");
    gotoxy(1, 4);
    cprintf("Press any key to continue.\n");
    gotoxy(1, 4);
    getch();
    init8h(1000);
    ticks_8h = 0;

    frame();

    gotoxy(1, 3);
    cprintf("Test delay8h(2000). Delay 2000 milliseconds (2 seconds).\n");
    gotoxy(1, 4);
    cprintf("Press any key to begin.\n");
    gotoxy(1, 4);
    getch();

    tick_1 = ticks_8h;
    gotoxy(1, 6);
    cprintf("tick_1=%u\n", tick_1);
    delay8h(2000);
    tick_2 = ticks_8h;
    gotoxy(1, 7);
    cprintf("tick_2=%u\n", tick_2);
    gotoxy(1, 8);
    printf("%u int8h ticks elapsed\n", (tick_2 - tick_1));
    elapsedtime = time8h(tick_1, tick_2);
    gotoxy(1, 9);
    printf("%u milliseconds elapsed\n", elapsedtime);

    gotoxy(1, 11);
    cprintf("Press any key to continue.\n");
    gotoxy(1, 11);
    getch();

    frame();

    gotoxy(1, 3);
    cprintf("Test sound8h(800, 300). Generate a 800 Hz sound for 300 ms.\n");
    gotoxy(1, 4);
    cprintf("Press any key to begin.\n");
    gotoxy(1, 4);
    getch();
    sound8h(800, 300);

    gotoxy(1, 6);
    cprintf("Press any key to continue.\n");
    gotoxy(1, 6);
    getch();

    frame();

    gotoxy(1, 3);
    cprintf("Measuring five reaction times.\n");
    gotoxy(1, 4);
    cprintf("Press any key to begin.\n");
    gotoxy(1, 4);
    getch();

    for (i = 0; i < 5; i++) {
        frame();
        tick_1 = ticks_8h;
        gotoxy(1, 3);
        cprintf("tick_1=%u\n", tick_1);
        gotoxy(1, 4);
        cprintf("Press any key to stop timer.\n");
        gotoxy(1, 4);
        getch();
        tick_2 = ticks_8h;
        gotoxy(1, 5);
        cprintf("tick_2=%u\n", tick_2);
        gotoxy(1, 6);
        printf("%u int8h ticks elapsed\n", (tick_2 - tick_1));
        elapsedtime = time8h(tick_1, tick_2);
        gotoxy(1, 7);
        printf("%u milliseconds elapsed\n", elapsedtime);

        gotoxy(1, 9);
        cprintf("Press any key to continue.\n");
        gotoxy(1, 9);
        getch();
    }

    frame();
    gotoxy(1, 3);
    cprintf("Quit PCTIMER: quit8h(). Quit millisecond resolution timing routine.\n");
    gotoxy(1, 4);
    cprintf("Press any key to quit.\n");
    gotoxy(1, 4);
    getch();

    quit8h();

    clrscr();
    gotoxy(1, 1);
}

void            frame(void)
{
    clrscr();
    gotoxy(1, 1);
    cprintf("PCTIMER 1.3 Demonstration Program (PCTIMER/IRQ0)\n");
    gotoxy(1, 2);
    cprintf("--------------------------------------------------------------------------------\n");
    gotoxy(1, 22);
    cprintf("--------------------------------------------------------------------------------\n");
}
