/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 32                         
									      
 Demonstrates the use of wwarp - press q to end program execution.           
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 You must have the WGT1.PCX file in your executable dir.       
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>
#include <conio.h>


void main(void)
{
  short i, t, c, b;
  color pal[256];
  block wgt1;
  short top[320];
  short bot[320];
  short oldmode;                        /* Store previous video mode */

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  printf ("WGT Example #32\n\n");
  printf ("A full-screen bitmap is warped into various shapes using WWARP.\n");
  printf ("Press a key to warp the object into a new shape. Press Q to end.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();         /* Gets the current mode */
  vga256 ();                     /* Initialize graphics mode */

  wgt1 = wloadpcx ("wgt1.pcx", pal);   /* Load our image to play with */
  wsetpalette (0, 255, pal);           /* Set the palette */

  wcls (0);                            /* Clear screen with black */
  wclip (0, 0, 319, 199);              /* Use full screen */

  /* Note: wsline merely stores y coordinates of line in array. You may use
	   several calls with various x ranges to make curved lines */

  wsline (0, 199, 319, 0, top);               /* Set array top for diagonal line */
  wsline (0, 199, 319, 199, bot);             /* Array bot is horizontal line */
  wwarp (0, 319, top, bot, wgt1, NORMAL);     /* Warp image between lines */
  getch ();                                   /* Wait for key */
  /* squish it */

  wcls (0);                                   /* Clear screen */
  wsline (0, 0, 319, 199, top);               /* Set array top for diagonal line */
  wsline (0, 199, 319, 0, bot);               /* Array bot is horizontal line */
  wwarp (0, 319, top, bot, wgt1, NORMAL);     /* Warp image between lines */
  getch ();                                   /* Wait for key */
  /* squish it */

  wcls (0);                                   /* Clear screen */
  wsline (0, 100, 100, 0, top);               /* Now create arrow shape */
  wsline (101, 70, 218, 70, top);
  wsline (219, 0, 319, 100, top);

  wsline (0, 100, 100, 199, bot);
  wsline (101, 130, 218, 130, bot);
  wsline (219, 199, 319, 100, bot);
  wwarp (0, 319, top, bot, wgt1, NORMAL);     /* Warp image using arrays */
  getch ();                                   /* Wait for keypress */
  /* make a double arrow */

  wcls (0);                              /* Clear screen with black */
  do
  {
    b = rand () % 100;
    c = (rand () % 100) + 100;
    for (t = 0; t <= 319; t++)
    {
      i = rand () % 2;
      if (i == 0) 
	b++; 
      else b--;
      i = rand () % 2;
      if (i == 0) 
	c++; 
      else c--;
      if (b > 100) 
	b = 100;
      if (b < 0) 
	b = 0;
      if (c > 197) 
	c = 197;
      if (c < 100) 
	c = 100;

      top[t] = b;                         /* Create random wavy lines */
      bot[t] = c;
    }
    wwarp (0, rand () % 320, top, bot, wgt1, XRAY); /* And warp image between them */
    i = getch ();                                   /* Wait for keypress */
  } while (i != 'q');                               /* End program if Q pressed */

  wfreeblock (wgt1);                     /* Free memory from image */
  wsetmode (oldmode);                    /* Restore initial video mode */
}
