
/*
    SCR.HPP
	Created 1994 by Dejvid Zaninovic
*/

#ifndef SCR_HPP
#define SCR_HPP

#include <conio.h>

#define C(f,b) f|(b<<4)     // create attrib

void scr_init();        // save screen status
void scr_close();       // restore screen status

unsigned getcursorshape();				// return cursor shape
void setcursorshape (unsigned shape);	// set cursor shape

putxych (int x, int y, int c);		// put char on x,y
cputc (int c);						// put char, no curs update
cputxyc (int x, int y, int c);		// on x,y
cgetc();							// get char
cputca (int c, int attr);			// put char & attr, no curs update
cputxyca (int x, int y, int c, int attr);	// on x, y
cgetca (int &c, int &attr);			// get char & attr
cputcn (int c, int repeat);			// put char n times, no curs update
cputxycn (int x, int y, int c, int repeat);	// on x, y
cputcan (int c, int attr, int n);	// put char & attr n times, no curs update
cputxycan (int x, int y, int c, int attr, int n);	// on x,y

fill (int x1, int y1, int x2, int y2, int c);   // fill region
fillall (int c);                                // fill whole screen

select (int x, int y, int len);         // select
unselect (int x, int y, int len);       // unselect

void box (int x1, int y1, int x2, int y2, char *boxchar);   // draw box

extern text_info ti;        // text mode info
extern void *scrbuf;        // saved screen buffer
extern unsigned cursor0;    // saved cursor
extern unsigned x0, y0;     // saved cursor position
extern char bsingle[];		// box single
extern char bdouble[];		// box double
extern int c_fill;			// fill attr
extern int c_box;			// box attr
extern int c_item;			// item attr
extern int c_sitem;			// selected item attr

inline void cursoroff() 
{
	_setcursortype (_NOCURSOR);
}

inline void cursoron() 
{
	_setcursortype (_NORMALCURSOR);
}

inline void cursorblock() 
{
	_setcursortype (_SOLIDCURSOR);
}

#endif
