1.1.1. Introduction
2.1.1. Output file
2.2.1. Binary output file
2.3.1. Monk output file
2.4.1. T output file
2.5.1. Motorola output file
2.6.1. Intel output file
3.1.1. Command line format


1.1.1. Introduction

DL is used to translate the IEE695 format of the absolute output file generated by LINK into a binary image which may be downloaded to the target.

Each invocation of DLcan concatenate as many overlays as desired into
a single image.  This allows relocation of overlays at different
addresses and then combining them to create a PROMimage.  For example
if LINK is used to create a code segment and a data segment; DL can be used
to concatenate the two segments into one image and startup code could be
used to move the data part from ROM to RAM at run time.

2.1.1. Output file

several output file formats are provided.  The default output file is a strict binary image created by extracting the requested overlay.  Optionally, one of two 1.44MB disk formats is supported.  A 256 Bytes Per Sector (BPS) format is compatible with MONK, by Peripheral Technologies, and a 1024 BPS format is compatible with other software by technoVenture.

Other file formats are Intel Hex and Motorola S-Record.

DL is only capable of translating one OVERLAY image to an output file
per invocation.

2.2.1. Binary output file

In the default case the output file is a strict binary version of the code generated by the linker.  The name of the input file is used and the extension is replaced with .IMG.  Path specifications on the input file are ignored and the output file is written to the current directory.

2.3.1. Monk output file

The Monk format is a 256BPS disk format.  It consists of the binary data and additionally record markers telling where to load the data and the execution address.  The first 6 bytes of each 256 byte block are as follows:

 0: (2) Track of next block(1-80)
 2: (2) Sector of next block(1-68)
 There are 34 sectors/side/track; sectors numbered greater
 than 34 are intended for the second side.
 4: (2) Relative block number

In the first block, the first record starts at offset 6.  There are two record formats; one to load data and one to specify the executionaddress.  Each record has an associated length; this length does not include the block headers that will be encountered at the beginning of each sector.  The record to load data is as follows:

 0: (1) A$1 record type
 1:(2) Length of record
 2: (4) Address to load data at
 7: Beginning of data

This type of record allows a convenient method of loading data at a variety of arbitrary addresses,  However, DN68K does not support multiple such records; it embeds the entire text of the code into one such record.

The Record to initiate program execution is as follows:

 0:(1) A$16 record type
 1: (4) Execution address of program

When this record is encountered, Monk resets the hardware and executes the
program.

In addition to this file format, Monk requires that track 1 sector 1
have 4 bytes of information at the beginning which tell the track and
sector of the program to load.

2.4.1. T output file

The T basic format is a 1024BPS format.  Sectors are numbered relativelyrather than in the track, sector format.  There are 10 tracks/sector/side.  This is a total of 20 sectors/track.  Sectors are numbered as follows:

 Track 0, Sector 1: 0
 Track 0, Sector 2: 1
 Track 0, Sector 10: 9
 Track 0, Sector 20: 19
 Track 1, Sector 1: 20
 Track 1, Sector 10: 29
 Track 1, Sector 20: 39
 Track 4, Sector 1: 80
 Track 50, Sector 1: 10

and so on.

In this format the image is assumed to be contiguous.  Download software is written on the target which presumes a specific load address which is compatible with the ROMs on that target.  The download software presumesthat the code is written to be pc-relative and relocates the program to a location in RAM.

The first 8 bytes of each sector give the sector number of the next sectorto load.  The remaining bytes in the sector are the next part of the contiguous image.

In this format, the disk loaders expect the first 12 bytes of Track 0,Sector 1 to hold useful information.  The first four bytes are the lengthof the image, and the next 8 bytes are sector number of the first sector in the image.

2.5.1. Motorola S-Records

This is the standard motorola S-RECORDformat.  Futures versions of this
manual will cover it in detail.

2.6.1. Intel Hex

This is the standard intel 16-bit segmented format.  Future versions of
this manual will cover it in detail.

3.1.1. Command line format

dl [/b??/p] /cname filename

Use of /c is mandatory; it is the name of the overlay to be extracted.
multiple overlays can be specified by seperating overlay names by a ';'
character.  Thus:

 dl /cCODE;DATA

extracts the overlays named code and data and concatenates them together.
The overlays may be extracted into seperate files if desired and handled
seperately.

Filename is the input file name.

The /p and /bm switches create an image compatible with PHI or MONK
disk loaders.

The /bmc switch produces motorola s-records.
The /bi switch produces intel hex records.

The output file name varies with the output desired.  Filenames are
as follows:

Binary images (no image qualifier switches) - .img
PHI images - .pmg
Monk images - .mnk
HEX images (either motorola or intel)- .HEX
