1.1.1. Introduction

The relocatable object file format is a subset of the IE-695 standard.  Relocatable files generated by LADsoft tools should be intelligible to an IE695 standard linker; however LINK does not meet the IE695 minimal standards and may not be useful with programs generated by translators other than those provided by LADsoft.

The IE695 ASCII format was selected for readability.  At some time in the future it may be replaced with a binary format to speed links; however this is not currently planned.

This document is not a comprehensive guide to IE695; it is instead a brief guide to the subset used in the LADsoft tools.

LADsoft tools may generate extra named sections with debug information
in them; such sections will have the characters "??" as the first characters
of the section name.

2.1.1. Brief guide to linker format

Each line in the relocatable object file starts with a two-letter command and ends with a '.'.  Symbols with periods in them may be embedded in the text so the location of the ending periodis context-sensitive.

Command list:

MB - module begin.  This gives the system type and file name.  System
 type is up to the implementer, X680Y0PHIDOS where X is I (integer)
 or F (floating point) and Y is the processor type of the highest-
 level instruction which was coded.

ME - module end.

DT - module date and time

CS - checksum.  Placement and usage is arbitrary.

AD - defines the bits in a minimum architectural unit (byte in our 
 case) and the max number of architectural units/address.  It
 also defines the endianness-'M' is big-endian and 'L' is
 little-endian.

ST# - defines a section #, gives it various attributes and a name.
 The linker may add more attributes depending on the 
 specification file- 'C' means it is to be merged commonly with
 other sections of the same name.

SA# - defines the alignment for a section.  The assembler generates a  number depending on the .align statements in the sections along  with anyprocessor-specific requirements.
 
ASS# - defines the size of a section.  Used for linking

ASL# - defines the location of a section.  Linker outputs this in a 
 .ABS file but it will not be present in .o files

NX# - define an external symbol name

NN#- define a local symbol name

NI# - define a public symbol name

ASI# - define the section and offset for a public symbol
 This is in standard IE expression format; however the linker
 assumes fixed fields rather than evaluating the expression

ASN# - define the section and offset for a local symbol
 This is in standard IE expression format; however the linker
 assumes fixed fields rather than evaluating the expression

CO# - define a comment with comment level #.
 Currently defined levels are:
 $100 - link pass seperator
 $101 - header end marker
 $102 - dependency file specifications
$103 - undefined
$104 - linker configuration record
 $105 - line number dependency files

SB# - Section begin.  Data loaded after this will go in the section
 this indicates.

LD - pure data that doesn't have to be fixed up.  This is a hex dump.

LR - a fixup record.
 In the parenthesis there are basically two expressions, 
 seperated by a comma.  Expressions can be postfix expressions 
 which have been arbitrarily limited to "+" and "-" functions, and
 each element of an expression is seperated by a comma.  So 
 there can be some confusion as to what is going on.  In the
 expressions there can be references to internal
 variables which have been assigned via the AS command or
 implicitly through linker fixups.  Each section has an R#
 variable which indicates the relative start of that section;
 thus if a fixup is relative to a section it will be based on
 an R# calculation.  X# variables are associated with externals;
 when the linker matches externals and publics the X# variable
 will be resolved to equal the corresponding I# variable which 
 was assigned with the ASI# command.  The other variable is the
 P variable, it is used to to PC-relative fixups.

 The first expression is the address to fix up, the second 
 expression is the number of MAUs (bytes) in the fixup.  Note that
 it is possible to get "fixup out of range" messages from the linker,
 if the size of a location or relative location is word but it is
 not within the specified memory size.

LR instructions define space in the image in addition to the
space defined in the LD instructions rather than overwriting it.
 
 No load address is provided in LRand LD instructions; the load  addressis derived from the corresponding L variable (ASL#
 instruction) and the number of bytes previously loaded.
