/**********************************************************************
 *  
 *  NAME:           aedef.h
 *  
 *  DESCRIPTION:    simple types, defs I use a lot
 *  
 *  This file is placed in the public domain.
 *
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  04/90       J. Alan Eldridge    created  
 *
 *  11/10/90    JAE                 name changed from aetype to aedef
 *  
 *  10/26/91    JAE                 added support for DJ Delorie's port
 *                                  port of GNU C++ v. 1.39
 *
 *********************************************************************/


#if !defined(__AEDEF_H)

#define __AEDEF_H   1

#define INCL_CONIO      1

#if defined(__TURBOC__)
#define INCL_MEM        1
#define INCL_DOS        1
#define INCL_IOSTREAM   1
#endif

#include    "aecc.h"    /*  get compiler includes   */

/*
    scalar types: upper & lower case 
*/

typedef signed char     SCHAR;
typedef unsigned char   UCHAR;
typedef unsigned int    UINT;
typedef unsigned short  USHORT;
typedef unsigned long   ULONG;
    
typedef signed char     schar;
typedef unsigned char   uchar;
typedef unsigned int    uint;
typedef unsigned short  ushort;
typedef unsigned long   ulong;
    
/*
    function return values 
*/

#define OK  0
#define ERR -1

/*
    TRUE & FALSE
*/

#define TRUE    1
#define FALSE   0
    
#if defined(__cplusplus)

#undef  min
#undef  max

/*
    min, max functions
*/
    
inline long min(long a, long b) { return a < b ? a : b; }
inline long max(long a, long b) { return a > b ? a : b; }

inline short  min(short a, short b)   { return a < b ? a : b; }
inline short  max(short a, short b)   { return a > b ? a : b; }

#endif  /*  defined(__cplusplus)    */

#endif  /*  !defined(__AEDEF_H) */
