/**********************************************************************
 *  
 *  NAME:           keybd.h
 *  
 *  DESCRIPTION:    keyboard interface
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  08/14/90    J. Alan Eldridge    created
 *  
 *  12/21/90    JAE                 un-object oriented it, because it
 *                                  just didn't seem to fit
 *
 *********************************************************************/

#ifndef __KEYBD_H
#define __KEYBD_H

//  These are the logical key values returned by the virtual keyboard

//  null character

#define K_NUL       0

//  common keys

#define K_ESC       27
#define K_TAB       '\t'
#define K_NL        '\n'
#define K_CR        '\r'
#define K_BACK      '\b'
#define K_BS        '\b'
#define K_SPACE     ' '

//  control keys

#define K_CTLKEY(c) ((c) - '@')

#define K_CTLA      K_CTLKEY('A')
#define K_CTLB      K_CTLKEY('B')
#define K_CTLC      K_CTLKEY('C')
#define K_CTLD      K_CTLKEY('D')
#define K_CTLE      K_CTLKEY('E')
#define K_CTLF      K_CTLKEY('F')
#define K_CTLG      K_CTLKEY('G')
#define K_CTLH      K_CTLKEY('H')
#define K_CTLI      K_CTLKEY('I')
#define K_CTLJ      K_CTLKEY('J')
#define K_CTLK      K_CTLKEY('K')
#define K_CTLL      K_CTLKEY('L')
#define K_CTLM      K_CTLKEY('M')
#define K_CTLN      K_CTLKEY('N')
#define K_CTLO      K_CTLKEY('O')
#define K_CTLP      K_CTLKEY('P')
#define K_CTLQ      K_CTLKEY('Q')
#define K_CTLR      K_CTLKEY('R')
#define K_CTLS      K_CTLKEY('S')
#define K_CTLT      K_CTLKEY('T')
#define K_CTLU      K_CTLKEY('U')
#define K_CTLV      K_CTLKEY('V')
#define K_CTLW      K_CTLKEY('W')
#define K_CTLX      K_CTLKEY('X')
#define K_CTLY      K_CTLKEY('Y')
#define K_CTLZ      K_CTLKEY('Z')

#define K_CTL_BKSLASH    K_CTLKEY('\\')

//  modifier bits (in high byte)

#define K_EXT       0x0100
#define K_ALT       0x0200 
#define K_CTL       0x0400
#define K_SHIFT     0x0800

//  shift tab key (backtab)

#define K_BACKTAB   (K_TAB | K_SHIFT)

//  function keys

#define K_F1        (130 | K_EXT)
#define K_F2        ((K_F1) + 1)
#define K_F3        ((K_F1) + 2)
#define K_F4        ((K_F1) + 3)
#define K_F5        ((K_F1) + 4)
#define K_F6        ((K_F1) + 5)
#define K_F7        ((K_F1) + 6)
#define K_F8        ((K_F1) + 7)
#define K_F9        ((K_F1) + 8)
#define K_F10       ((K_F1) + 9)
#define K_F11       ((K_F1) + 10)
#define K_F12       ((K_F1) + 11)

//  cursor movement keys

#define K_HOME      (150 | K_EXT)
#define K_UP        (151 | K_EXT)
#define K_PGUP      (152 | K_EXT)
#define K_LEFT      (153 | K_EXT)
#define K_RIGHT     (154 | K_EXT)
#define K_END       (155 | K_EXT)
#define K_DOWN      (156 | K_EXT)
#define K_PGDN      (157 | K_EXT)

//  insert and delete

#define K_INS       (158 | K_EXT)
#define K_DEL       (159 | K_EXT)

//  print screen key

#define K_PRTSC     (160 | K_EXT)

//  unknown key

#define K_UNKNOWN   (255 | K_EXT)

//  impossible value

#define K_ILLEGAL   -1

//  device interface routines

inline int  kbd_ready()     //  is a key available?
    { return kbhit(); }
    
int kbd_getkey();   //  (wait for and) get next key

//  like strchr(), but for key values

int findkey(int *arr, int key);

#endif

